@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enableDownloadPrivilege Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
 * @property labelSecurity Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
 * @property objectCreatorHasAccessPermission Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
 * @property objectCreatorHasGrantPermission The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
 * @property projectProtection Project protection.
 * @property usingAcl Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
 * @property usingPolicy Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
 */
public data class GetProjectsProjectSecurityProperties(
    public val enableDownloadPrivilege: Boolean,
    public val labelSecurity: Boolean,
    public val objectCreatorHasAccessPermission: Boolean,
    public val objectCreatorHasGrantPermission: Boolean,
    public val projectProtection: GetProjectsProjectSecurityPropertiesProjectProtection,
    public val usingAcl: Boolean,
    public val usingPolicy: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.GetProjectsProjectSecurityProperties): GetProjectsProjectSecurityProperties = GetProjectsProjectSecurityProperties(
            enableDownloadPrivilege = javaType.enableDownloadPrivilege(),
            labelSecurity = javaType.labelSecurity(),
            objectCreatorHasAccessPermission = javaType.objectCreatorHasAccessPermission(),
            objectCreatorHasGrantPermission = javaType.objectCreatorHasGrantPermission(),
            projectProtection = javaType.projectProtection().let({ args0 ->
                com.pulumi.alicloud.maxcompute.kotlin.outputs.GetProjectsProjectSecurityPropertiesProjectProtection.Companion.toKotlin(args0)
            }),
            usingAcl = javaType.usingAcl(),
            usingPolicy = javaType.usingPolicy(),
        )
    }
}
