@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipList Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.> **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
 * @property vpcIpList Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.> **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
 */
public data class ProjectIpWhiteList(
    public val ipList: String? = null,
    public val vpcIpList: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.ProjectIpWhiteList): ProjectIpWhiteList = ProjectIpWhiteList(
            ipList = javaType.ipList().map({ args0 -> args0 }).orElse(null),
            vpcIpList = javaType.vpcIpList().map({ args0 -> args0 }).orElse(null),
        )
    }
}
