@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allowFullScan Whether to allow full table scan. Default: false.
 * @property enableDecimal2 Whether to turn on Decimal2.0.
 * @property encryption Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
 * > **NOTE :**:  To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.  To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.  You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
 * @property retentionDays Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off. The effective policy after adjusting the backup cycle is: Extend the backup cycle: The new backup cycle takes effect on the same day. Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
 * @property sqlMeteringMax Set the maximum threshold of single SQL consumption, that is, set the ODPS. SQL. metering.value.max attribute. For details, see [Consumption Monitoring Alarm](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control). Unit: scan volume (GB)* complexity. .
 * @property tableLifecycle Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property,. See `table_lifecycle` below.
 * @property timezone Project time zone, example value: Asia/Shanghai.
 * @property typeSystem Data type version. Value:(1/2/hive) 1: The original MaxCompute type system. 2: New type system introduced by MaxCompute 2.0. hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
 */
public data class ProjectProperties(
    public val allowFullScan: Boolean? = null,
    public val enableDecimal2: Boolean? = null,
    public val encryption: ProjectPropertiesEncryption? = null,
    public val retentionDays: Int? = null,
    public val sqlMeteringMax: String? = null,
    public val tableLifecycle: ProjectPropertiesTableLifecycle? = null,
    public val timezone: String? = null,
    public val typeSystem: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.ProjectProperties): ProjectProperties = ProjectProperties(
            allowFullScan = javaType.allowFullScan().map({ args0 -> args0 }).orElse(null),
            enableDecimal2 = javaType.enableDecimal2().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectPropertiesEncryption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionDays = javaType.retentionDays().map({ args0 -> args0 }).orElse(null),
            sqlMeteringMax = javaType.sqlMeteringMax().map({ args0 -> args0 }).orElse(null),
            tableLifecycle = javaType.tableLifecycle().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectPropertiesTableLifecycle.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timezone = javaType.timezone().map({ args0 -> args0 }).orElse(null),
            typeSystem = javaType.typeSystem().map({ args0 -> args0 }).orElse(null),
        )
    }
}
