@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property algorithm The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
 * @property enable Only enable function is supported. Value: (true).
 * @property key The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
 */
public data class ProjectPropertiesEncryption(
    public val algorithm: String? = null,
    public val enable: Boolean? = null,
    public val key: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.ProjectPropertiesEncryption): ProjectPropertiesEncryption = ProjectPropertiesEncryption(
            algorithm = javaType.algorithm().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
        )
    }
}
