@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enableDownloadPrivilege Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
 * @property labelSecurity Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
 * @property objectCreatorHasAccessPermission Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
 * @property objectCreatorHasGrantPermission The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
 * @property projectProtection Project protection. See `project_protection` below.
 * @property usingAcl Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
 * @property usingPolicy Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
 */
public data class ProjectSecurityProperties(
    public val enableDownloadPrivilege: Boolean? = null,
    public val labelSecurity: Boolean? = null,
    public val objectCreatorHasAccessPermission: Boolean? = null,
    public val objectCreatorHasGrantPermission: Boolean? = null,
    public val projectProtection: ProjectSecurityPropertiesProjectProtection? = null,
    public val usingAcl: Boolean? = null,
    public val usingPolicy: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.ProjectSecurityProperties): ProjectSecurityProperties = ProjectSecurityProperties(
            enableDownloadPrivilege = javaType.enableDownloadPrivilege().map({ args0 -> args0 }).orElse(null),
            labelSecurity = javaType.labelSecurity().map({ args0 -> args0 }).orElse(null),
            objectCreatorHasAccessPermission = javaType.objectCreatorHasAccessPermission().map({ args0 ->
                args0
            }).orElse(null),
            objectCreatorHasGrantPermission = javaType.objectCreatorHasGrantPermission().map({ args0 ->
                args0
            }).orElse(null),
            projectProtection = javaType.projectProtection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectSecurityPropertiesProjectProtection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            usingAcl = javaType.usingAcl().map({ args0 -> args0 }).orElse(null),
            usingPolicy = javaType.usingPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
