@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin

import com.pulumi.alicloud.message.MessageFunctions.getServiceQueuesPlain
import com.pulumi.alicloud.message.MessageFunctions.getServiceSubscriptionsPlain
import com.pulumi.alicloud.message.MessageFunctions.getServiceTopicsPlain
import com.pulumi.alicloud.message.kotlin.inputs.GetServiceQueuesPlainArgs
import com.pulumi.alicloud.message.kotlin.inputs.GetServiceQueuesPlainArgsBuilder
import com.pulumi.alicloud.message.kotlin.inputs.GetServiceSubscriptionsPlainArgs
import com.pulumi.alicloud.message.kotlin.inputs.GetServiceSubscriptionsPlainArgsBuilder
import com.pulumi.alicloud.message.kotlin.inputs.GetServiceTopicsPlainArgs
import com.pulumi.alicloud.message.kotlin.inputs.GetServiceTopicsPlainArgsBuilder
import com.pulumi.alicloud.message.kotlin.outputs.GetServiceQueuesResult
import com.pulumi.alicloud.message.kotlin.outputs.GetServiceSubscriptionsResult
import com.pulumi.alicloud.message.kotlin.outputs.GetServiceTopicsResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.message.kotlin.outputs.GetServiceQueuesResult.Companion.toKotlin as getServiceQueuesResultToKotlin
import com.pulumi.alicloud.message.kotlin.outputs.GetServiceSubscriptionsResult.Companion.toKotlin as getServiceSubscriptionsResultToKotlin
import com.pulumi.alicloud.message.kotlin.outputs.GetServiceTopicsResult.Companion.toKotlin as getServiceTopicsResultToKotlin

public object MessageFunctions {
    /**
     * This data source provides the Message Notification Service Queues of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.188.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.message.getServiceQueues({
     *     ids: ["example_id"],
     * });
     * export const queueId1 = ids.then(ids => ids.queues?.[0]?.id);
     * const name = alicloud.message.getServiceQueues({
     *     queueName: "tf-example",
     * });
     * export const queueId2 = name.then(name => name.queues?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.message.get_service_queues(ids=["example_id"])
     * pulumi.export("queueId1", ids.queues[0].id)
     * name = alicloud.message.get_service_queues(queue_name="tf-example")
     * pulumi.export("queueId2", name.queues[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Message.GetServiceQueues.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var name = AliCloud.Message.GetServiceQueues.Invoke(new()
     *     {
     *         QueueName = "tf-example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["queueId1"] = ids&#46;Apply(getServiceQueuesResult => getServiceQueuesResult&#46;Queues[0]?.Id),
     *         ["queueId2"] = name&#46;Apply(getServiceQueuesResult => getServiceQueuesResult&#46;Queues[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/message"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := message.GetServiceQueues(ctx, &message.GetServiceQueuesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("queueId1", ids.Queues[0].Id)
     * 		name, err := message.GetServiceQueues(ctx, &message.GetServiceQueuesArgs{
     * 			QueueName: pulumi.StringRef("tf-example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("queueId2", name.Queues[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.message.MessageFunctions;
     * import com.pulumi.alicloud.message.inputs.GetServiceQueuesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = MessageFunctions.getServiceQueues(GetServiceQueuesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("queueId1", ids.applyValue(getServiceQueuesResult -> getServiceQueuesResult.queues()[0].id()));
     *         final var name = MessageFunctions.getServiceQueues(GetServiceQueuesArgs.builder()
     *             .queueName("tf-example")
     *             .build());
     *         ctx.export("queueId2", name.applyValue(getServiceQueuesResult -> getServiceQueuesResult.queues()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:message:getServiceQueues
     *       Arguments:
     *         ids:
     *           - example_id
     *   name:
     *     fn::invoke:
     *       Function: alicloud:message:getServiceQueues
     *       Arguments:
     *         queueName: tf-example
     * outputs:
     *   queueId1: ${ids.queues[0].id}
     *   queueId2: ${name.queues[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServiceQueues.
     * @return A collection of values returned by getServiceQueues.
     */
    public suspend fun getServiceQueues(argument: GetServiceQueuesPlainArgs): GetServiceQueuesResult =
        getServiceQueuesResultToKotlin(getServiceQueuesPlain(argument.toJava()).await())

    /**
     * @see [getServiceQueues].
     * @param ids A list of Queue IDs. Its element value is same as Queue Name.
     * @param nameRegex A regex string to filter results by Queue name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param queueName The name of the queue.
     * @return A collection of values returned by getServiceQueues.
     */
    public suspend fun getServiceQueues(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        queueName: String? = null,
    ): GetServiceQueuesResult {
        val argument = GetServiceQueuesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            queueName = queueName,
        )
        return getServiceQueuesResultToKotlin(getServiceQueuesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceQueues].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;message&#46;kotlin&#46;inputs&#46;GetServiceQueuesPlainArgs].
     * @return A collection of values returned by getServiceQueues.
     */
    public suspend fun getServiceQueues(argument: suspend GetServiceQueuesPlainArgsBuilder.() -> Unit): GetServiceQueuesResult {
        val builder = GetServiceQueuesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceQueuesResultToKotlin(getServiceQueuesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Message Notification Service Subscriptions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.188.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.message.getServiceSubscriptions({
     *     ids: ["example_id"],
     *     topicName: "tf-example",
     * });
     * export const subscriptionId1 = ids.then(ids => ids.subscriptions?.[0]?.id);
     * const name = alicloud.message.getServiceSubscriptions({
     *     topicName: "tf-example",
     * });
     * export const subscriptionId2 = name.then(name => name.subscriptions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.message.get_service_subscriptions(ids=["example_id"],
     *     topic_name="tf-example")
     * pulumi.export("subscriptionId1", ids.subscriptions[0].id)
     * name = alicloud.message.get_service_subscriptions(topic_name="tf-example")
     * pulumi.export("subscriptionId2", name.subscriptions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Message.GetServiceSubscriptions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TopicName = "tf-example",
     *     });
     *     var name = AliCloud.Message.GetServiceSubscriptions.Invoke(new()
     *     {
     *         TopicName = "tf-example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["subscriptionId1"] = ids&#46;Apply(getServiceSubscriptionsResult => getServiceSubscriptionsResult&#46;Subscriptions[0]?.Id),
     *         ["subscriptionId2"] = name&#46;Apply(getServiceSubscriptionsResult => getServiceSubscriptionsResult&#46;Subscriptions[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/message"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := message.GetServiceSubscriptions(ctx, &message.GetServiceSubscriptionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TopicName: "tf-example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("subscriptionId1", ids.Subscriptions[0].Id)
     * 		name, err := message.GetServiceSubscriptions(ctx, &message.GetServiceSubscriptionsArgs{
     * 			TopicName: "tf-example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("subscriptionId2", name.Subscriptions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.message.MessageFunctions;
     * import com.pulumi.alicloud.message.inputs.GetServiceSubscriptionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = MessageFunctions.getServiceSubscriptions(GetServiceSubscriptionsArgs.builder()
     *             .ids("example_id")
     *             .topicName("tf-example")
     *             .build());
     *         ctx.export("subscriptionId1", ids.applyValue(getServiceSubscriptionsResult -> getServiceSubscriptionsResult.subscriptions()[0].id()));
     *         final var name = MessageFunctions.getServiceSubscriptions(GetServiceSubscriptionsArgs.builder()
     *             .topicName("tf-example")
     *             .build());
     *         ctx.export("subscriptionId2", name.applyValue(getServiceSubscriptionsResult -> getServiceSubscriptionsResult.subscriptions()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:message:getServiceSubscriptions
     *       Arguments:
     *         ids:
     *           - example_id
     *         topicName: tf-example
     *   name:
     *     fn::invoke:
     *       Function: alicloud:message:getServiceSubscriptions
     *       Arguments:
     *         topicName: tf-example
     * outputs:
     *   subscriptionId1: ${ids.subscriptions[0].id}
     *   subscriptionId2: ${name.subscriptions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServiceSubscriptions.
     * @return A collection of values returned by getServiceSubscriptions.
     */
    public suspend fun getServiceSubscriptions(argument: GetServiceSubscriptionsPlainArgs): GetServiceSubscriptionsResult =
        getServiceSubscriptionsResultToKotlin(getServiceSubscriptionsPlain(argument.toJava()).await())

    /**
     * @see [getServiceSubscriptions].
     * @param ids A list of Subscription IDs.
     * @param nameRegex A regex string to filter results by Subscription name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param subscriptionName The name of the subscription.
     * @param topicName The name of the topic.
     * @return A collection of values returned by getServiceSubscriptions.
     */
    public suspend fun getServiceSubscriptions(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        subscriptionName: String? = null,
        topicName: String,
    ): GetServiceSubscriptionsResult {
        val argument = GetServiceSubscriptionsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            subscriptionName = subscriptionName,
            topicName = topicName,
        )
        return getServiceSubscriptionsResultToKotlin(getServiceSubscriptionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceSubscriptions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;message&#46;kotlin&#46;inputs&#46;GetServiceSubscriptionsPlainArgs].
     * @return A collection of values returned by getServiceSubscriptions.
     */
    public suspend fun getServiceSubscriptions(argument: suspend GetServiceSubscriptionsPlainArgsBuilder.() -> Unit): GetServiceSubscriptionsResult {
        val builder = GetServiceSubscriptionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceSubscriptionsResultToKotlin(getServiceSubscriptionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Message Notification Service Topics of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.188.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.message.getServiceTopics({
     *     ids: ["example_id"],
     * });
     * export const topicId1 = ids.then(ids => ids.topics?.[0]?.id);
     * const name = alicloud.message.getServiceTopics({
     *     topicName: "tf-example",
     * });
     * export const topicId2 = name.then(name => name.topics?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.message.get_service_topics(ids=["example_id"])
     * pulumi.export("topicId1", ids.topics[0].id)
     * name = alicloud.message.get_service_topics(topic_name="tf-example")
     * pulumi.export("topicId2", name.topics[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Message.GetServiceTopics.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var name = AliCloud.Message.GetServiceTopics.Invoke(new()
     *     {
     *         TopicName = "tf-example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["topicId1"] = ids&#46;Apply(getServiceTopicsResult => getServiceTopicsResult&#46;Topics[0]?.Id),
     *         ["topicId2"] = name&#46;Apply(getServiceTopicsResult => getServiceTopicsResult&#46;Topics[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/message"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := message.GetServiceTopics(ctx, &message.GetServiceTopicsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("topicId1", ids.Topics[0].Id)
     * 		name, err := message.GetServiceTopics(ctx, &message.GetServiceTopicsArgs{
     * 			TopicName: pulumi.StringRef("tf-example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("topicId2", name.Topics[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.message.MessageFunctions;
     * import com.pulumi.alicloud.message.inputs.GetServiceTopicsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = MessageFunctions.getServiceTopics(GetServiceTopicsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("topicId1", ids.applyValue(getServiceTopicsResult -> getServiceTopicsResult.topics()[0].id()));
     *         final var name = MessageFunctions.getServiceTopics(GetServiceTopicsArgs.builder()
     *             .topicName("tf-example")
     *             .build());
     *         ctx.export("topicId2", name.applyValue(getServiceTopicsResult -> getServiceTopicsResult.topics()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:message:getServiceTopics
     *       Arguments:
     *         ids:
     *           - example_id
     *   name:
     *     fn::invoke:
     *       Function: alicloud:message:getServiceTopics
     *       Arguments:
     *         topicName: tf-example
     * outputs:
     *   topicId1: ${ids.topics[0].id}
     *   topicId2: ${name.topics[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServiceTopics.
     * @return A collection of values returned by getServiceTopics.
     */
    public suspend fun getServiceTopics(argument: GetServiceTopicsPlainArgs): GetServiceTopicsResult =
        getServiceTopicsResultToKotlin(getServiceTopicsPlain(argument.toJava()).await())

    /**
     * @see [getServiceTopics].
     * @param ids A list of Topic IDs. Its element value is same as Topic Name.
     * @param nameRegex A regex string to filter results by Topic name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param topicName The name of the topic.
     * @return A collection of values returned by getServiceTopics.
     */
    public suspend fun getServiceTopics(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        topicName: String? = null,
    ): GetServiceTopicsResult {
        val argument = GetServiceTopicsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            topicName = topicName,
        )
        return getServiceTopicsResultToKotlin(getServiceTopicsPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceTopics].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;message&#46;kotlin&#46;inputs&#46;GetServiceTopicsPlainArgs].
     * @return A collection of values returned by getServiceTopics.
     */
    public suspend fun getServiceTopics(argument: suspend GetServiceTopicsPlainArgsBuilder.() -> Unit): GetServiceTopicsResult {
        val builder = GetServiceTopicsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceTopicsResultToKotlin(getServiceTopicsPlain(builtArgument.toJava()).await())
    }
}
