@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceQueue].
 */
@PulumiTagMarker
public class ServiceQueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceQueueArgs = ServiceQueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceQueueArgsBuilder.() -> Unit) {
        val builder = ServiceQueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceQueue {
        val builtJavaResource = com.pulumi.alicloud.message.ServiceQueue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceQueue(builtJavaResource)
    }
}

/**
 * Provides a Message Service Queue resource.
 * For information about Message Service Queue and how to use it, see [What is Queue](https://www.alibabacloud.com/help/en/message-service/latest/createqueue).
 * > **NOTE:** Available since v1.188.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.message.ServiceQueue("default", {
 *     delaySeconds: 2,
 *     pollingWaitSeconds: 2,
 *     messageRetentionPeriod: 566,
 *     maximumMessageSize: 1123,
 *     visibilityTimeout: 30,
 *     queueName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.message.ServiceQueue("default",
 *     delay_seconds=2,
 *     polling_wait_seconds=2,
 *     message_retention_period=566,
 *     maximum_message_size=1123,
 *     visibility_timeout=30,
 *     queue_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Message.ServiceQueue("default", new()
 *     {
 *         DelaySeconds = 2,
 *         PollingWaitSeconds = 2,
 *         MessageRetentionPeriod = 566,
 *         MaximumMessageSize = 1123,
 *         VisibilityTimeout = 30,
 *         QueueName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/message"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := message.NewServiceQueue(ctx, "default", &message.ServiceQueueArgs{
 * 			DelaySeconds:           pulumi.Int(2),
 * 			PollingWaitSeconds:     pulumi.Int(2),
 * 			MessageRetentionPeriod: pulumi.Int(566),
 * 			MaximumMessageSize:     pulumi.Int(1123),
 * 			VisibilityTimeout:      pulumi.Int(30),
 * 			QueueName:              pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.message.ServiceQueue;
 * import com.pulumi.alicloud.message.ServiceQueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ServiceQueue("default", ServiceQueueArgs.builder()
 *             .delaySeconds("2")
 *             .pollingWaitSeconds("2")
 *             .messageRetentionPeriod("566")
 *             .maximumMessageSize("1123")
 *             .visibilityTimeout("30")
 *             .queueName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:message:ServiceQueue
 *     properties:
 *       delaySeconds: '2'
 *       pollingWaitSeconds: '2'
 *       messageRetentionPeriod: '566'
 *       maximumMessageSize: '1123'
 *       visibilityTimeout: '30'
 *       queueName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Message Service Queue can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:message/serviceQueue:ServiceQueue example <id>
 * ```
 */
public class ServiceQueue internal constructor(
    override val javaResource: com.pulumi.alicloud.message.ServiceQueue,
) : KotlinCustomResource(javaResource, ServiceQueueMapper) {
    /**
     * Represents the time when the Queue was created.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * This means that messages sent to the queue can only be consumed after the delay time set by this parameter, in seconds.
     */
    public val delaySeconds: Output<Int>
        get() = javaResource.delaySeconds().applyValue({ args0 -> args0 })

    /**
     * Represents whether the log management function is enabled.
     */
    public val loggingEnabled: Output<Boolean>?
        get() = javaResource.loggingEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Represents the maximum length of the message body sent to the Queue, in Byte.
     */
    public val maximumMessageSize: Output<Int>
        get() = javaResource.maximumMessageSize().applyValue({ args0 -> args0 })

    /**
     * Represents the longest life time of the message in the Queue.
     */
    public val messageRetentionPeriod: Output<Int>
        get() = javaResource.messageRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The longest waiting time for a Queue request when the number of messages is empty, in seconds.
     */
    public val pollingWaitSeconds: Output<Int>
        get() = javaResource.pollingWaitSeconds().applyValue({ args0 -> args0 })

    /**
     * Representative resources.
     */
    public val queueName: Output<String>
        get() = javaResource.queueName().applyValue({ args0 -> args0 })

    /**
     * Represents the duration after the message is removed from the Queue and changed from the Active state to the Inactive state.
     */
    public val visibilityTimeout: Output<Int>
        get() = javaResource.visibilityTimeout().applyValue({ args0 -> args0 })
}

public object ServiceQueueMapper : ResourceMapper<ServiceQueue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.message.ServiceQueue::class == javaResource::class

    override fun map(javaResource: Resource): ServiceQueue = ServiceQueue(
        javaResource as
            com.pulumi.alicloud.message.ServiceQueue,
    )
}

/**
 * @see [ServiceQueue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceQueue].
 */
public suspend fun serviceQueue(
    name: String,
    block: suspend ServiceQueueResourceBuilder.() -> Unit,
): ServiceQueue {
    val builder = ServiceQueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceQueue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceQueue(name: String): ServiceQueue {
    val builder = ServiceQueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
