@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin

import com.pulumi.alicloud.message.ServiceQueueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Message Service Queue resource.
 * For information about Message Service Queue and how to use it, see [What is Queue](https://www.alibabacloud.com/help/en/message-service/latest/createqueue).
 * > **NOTE:** Available since v1.188.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.message.ServiceQueue("default", {
 *     delaySeconds: 2,
 *     pollingWaitSeconds: 2,
 *     messageRetentionPeriod: 566,
 *     maximumMessageSize: 1123,
 *     visibilityTimeout: 30,
 *     queueName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.message.ServiceQueue("default",
 *     delay_seconds=2,
 *     polling_wait_seconds=2,
 *     message_retention_period=566,
 *     maximum_message_size=1123,
 *     visibility_timeout=30,
 *     queue_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Message.ServiceQueue("default", new()
 *     {
 *         DelaySeconds = 2,
 *         PollingWaitSeconds = 2,
 *         MessageRetentionPeriod = 566,
 *         MaximumMessageSize = 1123,
 *         VisibilityTimeout = 30,
 *         QueueName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/message"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := message.NewServiceQueue(ctx, "default", &message.ServiceQueueArgs{
 * 			DelaySeconds:           pulumi.Int(2),
 * 			PollingWaitSeconds:     pulumi.Int(2),
 * 			MessageRetentionPeriod: pulumi.Int(566),
 * 			MaximumMessageSize:     pulumi.Int(1123),
 * 			VisibilityTimeout:      pulumi.Int(30),
 * 			QueueName:              pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.message.ServiceQueue;
 * import com.pulumi.alicloud.message.ServiceQueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ServiceQueue("default", ServiceQueueArgs.builder()
 *             .delaySeconds("2")
 *             .pollingWaitSeconds("2")
 *             .messageRetentionPeriod("566")
 *             .maximumMessageSize("1123")
 *             .visibilityTimeout("30")
 *             .queueName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:message:ServiceQueue
 *     properties:
 *       delaySeconds: '2'
 *       pollingWaitSeconds: '2'
 *       messageRetentionPeriod: '566'
 *       maximumMessageSize: '1123'
 *       visibilityTimeout: '30'
 *       queueName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Message Service Queue can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:message/serviceQueue:ServiceQueue example <id>
 * ```
 * @property delaySeconds This means that messages sent to the queue can only be consumed after the delay time set by this parameter, in seconds.
 * @property loggingEnabled Represents whether the log management function is enabled.
 * @property maximumMessageSize Represents the maximum length of the message body sent to the Queue, in Byte.
 * @property messageRetentionPeriod Represents the longest life time of the message in the Queue.
 * @property pollingWaitSeconds The longest waiting time for a Queue request when the number of messages is empty, in seconds.
 * @property queueName Representative resources.
 * @property visibilityTimeout Represents the duration after the message is removed from the Queue and changed from the Active state to the Inactive state.
 */
public data class ServiceQueueArgs(
    public val delaySeconds: Output<Int>? = null,
    public val loggingEnabled: Output<Boolean>? = null,
    public val maximumMessageSize: Output<Int>? = null,
    public val messageRetentionPeriod: Output<Int>? = null,
    public val pollingWaitSeconds: Output<Int>? = null,
    public val queueName: Output<String>? = null,
    public val visibilityTimeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.message.ServiceQueueArgs> {
    override fun toJava(): com.pulumi.alicloud.message.ServiceQueueArgs =
        com.pulumi.alicloud.message.ServiceQueueArgs.builder()
            .delaySeconds(delaySeconds?.applyValue({ args0 -> args0 }))
            .loggingEnabled(loggingEnabled?.applyValue({ args0 -> args0 }))
            .maximumMessageSize(maximumMessageSize?.applyValue({ args0 -> args0 }))
            .messageRetentionPeriod(messageRetentionPeriod?.applyValue({ args0 -> args0 }))
            .pollingWaitSeconds(pollingWaitSeconds?.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .visibilityTimeout(visibilityTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceQueueArgs].
 */
@PulumiTagMarker
public class ServiceQueueArgsBuilder internal constructor() {
    private var delaySeconds: Output<Int>? = null

    private var loggingEnabled: Output<Boolean>? = null

    private var maximumMessageSize: Output<Int>? = null

    private var messageRetentionPeriod: Output<Int>? = null

    private var pollingWaitSeconds: Output<Int>? = null

    private var queueName: Output<String>? = null

    private var visibilityTimeout: Output<Int>? = null

    /**
     * @param value This means that messages sent to the queue can only be consumed after the delay time set by this parameter, in seconds.
     */
    @JvmName("sqcfqbejhtkdwttq")
    public suspend fun delaySeconds(`value`: Output<Int>) {
        this.delaySeconds = value
    }

    /**
     * @param value Represents whether the log management function is enabled.
     */
    @JvmName("vfbmxaaboofsnaqn")
    public suspend fun loggingEnabled(`value`: Output<Boolean>) {
        this.loggingEnabled = value
    }

    /**
     * @param value Represents the maximum length of the message body sent to the Queue, in Byte.
     */
    @JvmName("wjiyblvqcjqbpvjk")
    public suspend fun maximumMessageSize(`value`: Output<Int>) {
        this.maximumMessageSize = value
    }

    /**
     * @param value Represents the longest life time of the message in the Queue.
     */
    @JvmName("rmgoofapxulkbxab")
    public suspend fun messageRetentionPeriod(`value`: Output<Int>) {
        this.messageRetentionPeriod = value
    }

    /**
     * @param value The longest waiting time for a Queue request when the number of messages is empty, in seconds.
     */
    @JvmName("nyjtmuitqhrqodmh")
    public suspend fun pollingWaitSeconds(`value`: Output<Int>) {
        this.pollingWaitSeconds = value
    }

    /**
     * @param value Representative resources.
     */
    @JvmName("hfyfogtdyijpvilu")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value Represents the duration after the message is removed from the Queue and changed from the Active state to the Inactive state.
     */
    @JvmName("jixpawmscdjdnuft")
    public suspend fun visibilityTimeout(`value`: Output<Int>) {
        this.visibilityTimeout = value
    }

    /**
     * @param value This means that messages sent to the queue can only be consumed after the delay time set by this parameter, in seconds.
     */
    @JvmName("qsqnktkdxrnqqcjo")
    public suspend fun delaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delaySeconds = mapped
    }

    /**
     * @param value Represents whether the log management function is enabled.
     */
    @JvmName("oyobsqppejeaqpyj")
    public suspend fun loggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingEnabled = mapped
    }

    /**
     * @param value Represents the maximum length of the message body sent to the Queue, in Byte.
     */
    @JvmName("gbyjygrajtiqvxoc")
    public suspend fun maximumMessageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumMessageSize = mapped
    }

    /**
     * @param value Represents the longest life time of the message in the Queue.
     */
    @JvmName("bmpeotkvjbjweufo")
    public suspend fun messageRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageRetentionPeriod = mapped
    }

    /**
     * @param value The longest waiting time for a Queue request when the number of messages is empty, in seconds.
     */
    @JvmName("elgoxydminkpbvwu")
    public suspend fun pollingWaitSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pollingWaitSeconds = mapped
    }

    /**
     * @param value Representative resources.
     */
    @JvmName("yjvrctdptymgjbte")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value Represents the duration after the message is removed from the Queue and changed from the Active state to the Inactive state.
     */
    @JvmName("fkgljhbntahiknql")
    public suspend fun visibilityTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibilityTimeout = mapped
    }

    internal fun build(): ServiceQueueArgs = ServiceQueueArgs(
        delaySeconds = delaySeconds,
        loggingEnabled = loggingEnabled,
        maximumMessageSize = maximumMessageSize,
        messageRetentionPeriod = messageRetentionPeriod,
        pollingWaitSeconds = pollingWaitSeconds,
        queueName = queueName,
        visibilityTimeout = visibilityTimeout,
    )
}
