@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceSubscription].
 */
@PulumiTagMarker
public class ServiceSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceSubscriptionArgs = ServiceSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceSubscriptionArgsBuilder.() -> Unit) {
        val builder = ServiceSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceSubscription {
        val builtJavaResource = com.pulumi.alicloud.message.ServiceSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceSubscription(builtJavaResource)
    }
}

/**
 * Provides a Message Notification Service Subscription resource.
 * For information about Message Notification Service Subscription and how to use it, see [What is Subscription](https://www.alibabacloud.com/help/en/message-service/latest/subscribe-1).
 * > **NOTE:** Available since v1.188.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.message.ServiceTopic("default", {
 *     topicName: name,
 *     maxMessageSize: 12357,
 *     loggingEnabled: true,
 * });
 * const defaultServiceSubscription = new alicloud.message.ServiceSubscription("default", {
 *     topicName: _default.topicName,
 *     subscriptionName: name,
 *     endpoint: "http://example.com",
 *     pushType: "http",
 *     filterTag: "tf-example",
 *     notifyContentFormat: "XML",
 *     notifyStrategy: "BACKOFF_RETRY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.message.ServiceTopic("default",
 *     topic_name=name,
 *     max_message_size=12357,
 *     logging_enabled=True)
 * default_service_subscription = alicloud.message.ServiceSubscription("default",
 *     topic_name=default.topic_name,
 *     subscription_name=name,
 *     endpoint="http://example.com",
 *     push_type="http",
 *     filter_tag="tf-example",
 *     notify_content_format="XML",
 *     notify_strategy="BACKOFF_RETRY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Message.ServiceTopic("default", new()
 *     {
 *         TopicName = name,
 *         MaxMessageSize = 12357,
 *         LoggingEnabled = true,
 *     });
 *     var defaultServiceSubscription = new AliCloud.Message.ServiceSubscription("default", new()
 *     {
 *         TopicName = @default.TopicName,
 *         SubscriptionName = name,
 *         Endpoint = "http://example.com",
 *         PushType = "http",
 *         FilterTag = "tf-example",
 *         NotifyContentFormat = "XML",
 *         NotifyStrategy = "BACKOFF_RETRY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/message"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := message.NewServiceTopic(ctx, "default", &message.ServiceTopicArgs{
 * 			TopicName:      pulumi.String(name),
 * 			MaxMessageSize: pulumi.Int(12357),
 * 			LoggingEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = message.NewServiceSubscription(ctx, "default", &message.ServiceSubscriptionArgs{
 * 			TopicName:           _default.TopicName,
 * 			SubscriptionName:    pulumi.String(name),
 * 			Endpoint:            pulumi.String("http://example.com"),
 * 			PushType:            pulumi.String("http"),
 * 			FilterTag:           pulumi.String("tf-example"),
 * 			NotifyContentFormat: pulumi.String("XML"),
 * 			NotifyStrategy:      pulumi.String("BACKOFF_RETRY"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.message.ServiceTopic;
 * import com.pulumi.alicloud.message.ServiceTopicArgs;
 * import com.pulumi.alicloud.message.ServiceSubscription;
 * import com.pulumi.alicloud.message.ServiceSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new ServiceTopic("default", ServiceTopicArgs.builder()
 *             .topicName(name)
 *             .maxMessageSize(12357)
 *             .loggingEnabled(true)
 *             .build());
 *         var defaultServiceSubscription = new ServiceSubscription("defaultServiceSubscription", ServiceSubscriptionArgs.builder()
 *             .topicName(default_.topicName())
 *             .subscriptionName(name)
 *             .endpoint("http://example.com")
 *             .pushType("http")
 *             .filterTag("tf-example")
 *             .notifyContentFormat("XML")
 *             .notifyStrategy("BACKOFF_RETRY")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:message:ServiceTopic
 *     properties:
 *       topicName: ${name}
 *       maxMessageSize: 12357
 *       loggingEnabled: true
 *   defaultServiceSubscription:
 *     type: alicloud:message:ServiceSubscription
 *     name: default
 *     properties:
 *       topicName: ${default.topicName}
 *       subscriptionName: ${name}
 *       endpoint: http://example.com
 *       pushType: http
 *       filterTag: tf-example
 *       notifyContentFormat: XML
 *       notifyStrategy: BACKOFF_RETRY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Message Notification Service Subscription can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:message/serviceSubscription:ServiceSubscription example <topic_name>:<subscription_name>
 * ```
 */
public class ServiceSubscription internal constructor(
    override val javaResource: com.pulumi.alicloud.message.ServiceSubscription,
) : KotlinCustomResource(javaResource, ServiceSubscriptionMapper) {
    /**
     * The endpoint has three format. Available values format:
     * - `HTTP Format`: http://xxx.com/xxx
     * - `Queue Format`: acs:mns:{REGION}:{AccountID}:queues/{QueueName}
     * - `Email Format`: mail:directmail:{MailAddress}
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The tag that is used to filter messages. Only the messages that have the same tag can be pushed. A tag is a string that can be up to 16 characters in length. By default, no tag is specified to filter messages.
     */
    public val filterTag: Output<String>?
        get() = javaResource.filterTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The NotifyContentFormat attribute of Subscription. This attribute specifies the content format of the messages pushed to users. Valid values: `XML`, `JSON` and `SIMPLIFIED`. Default value: `XML`.
     */
    public val notifyContentFormat: Output<String>
        get() = javaResource.notifyContentFormat().applyValue({ args0 -> args0 })

    /**
     * The NotifyStrategy attribute of Subscription. This attribute specifies the retry strategy when message sending fails. Default value: `BACKOFF_RETRY`. Valid values:
     * - `BACKOFF_RETRY`: retries with a fixed backoff interval.
     * - `EXPONENTIAL_DECAY_RETRY`: retries with exponential backoff.
     */
    public val notifyStrategy: Output<String>
        get() = javaResource.notifyStrategy().applyValue({ args0 -> args0 })

    /**
     * The Push type of Subscription. The Valid values: `http`, `queue`, `mpush`, `alisms` and `email`.
     */
    public val pushType: Output<String>
        get() = javaResource.pushType().applyValue({ args0 -> args0 })

    /**
     * Two topics subscription on a single account in the same topic cannot have the same name. A topic subscription name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 255 characters.
     */
    public val subscriptionName: Output<String>
        get() = javaResource.subscriptionName().applyValue({ args0 -> args0 })

    /**
     * The topic which The subscription belongs to was named with the name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 255 characters.
     */
    public val topicName: Output<String>
        get() = javaResource.topicName().applyValue({ args0 -> args0 })
}

public object ServiceSubscriptionMapper : ResourceMapper<ServiceSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.message.ServiceSubscription::class == javaResource::class

    override fun map(javaResource: Resource): ServiceSubscription = ServiceSubscription(
        javaResource
            as com.pulumi.alicloud.message.ServiceSubscription,
    )
}

/**
 * @see [ServiceSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceSubscription].
 */
public suspend fun serviceSubscription(
    name: String,
    block: suspend ServiceSubscriptionResourceBuilder.() -> Unit,
): ServiceSubscription {
    val builder = ServiceSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceSubscription(name: String): ServiceSubscription {
    val builder = ServiceSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
