@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceTopic].
 */
@PulumiTagMarker
public class ServiceTopicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceTopicArgs = ServiceTopicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceTopicArgsBuilder.() -> Unit) {
        val builder = ServiceTopicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceTopic {
        val builtJavaResource = com.pulumi.alicloud.message.ServiceTopic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceTopic(builtJavaResource)
    }
}

/**
 * Provides a Message Notification Service Topic resource.
 * For information about Message Notification Service Topic and how to use it, see [What is Topic](https://www.alibabacloud.com/help/en/message-service/latest/createtopic).
 * > **NOTE:** Available since v1.188.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.message.ServiceTopic("default", {
 *     topicName: name,
 *     maxMessageSize: 12357,
 *     loggingEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.message.ServiceTopic("default",
 *     topic_name=name,
 *     max_message_size=12357,
 *     logging_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Message.ServiceTopic("default", new()
 *     {
 *         TopicName = name,
 *         MaxMessageSize = 12357,
 *         LoggingEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/message"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := message.NewServiceTopic(ctx, "default", &message.ServiceTopicArgs{
 * 			TopicName:      pulumi.String(name),
 * 			MaxMessageSize: pulumi.Int(12357),
 * 			LoggingEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.message.ServiceTopic;
 * import com.pulumi.alicloud.message.ServiceTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new ServiceTopic("default", ServiceTopicArgs.builder()
 *             .topicName(name)
 *             .maxMessageSize(12357)
 *             .loggingEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:message:ServiceTopic
 *     properties:
 *       topicName: ${name}
 *       maxMessageSize: 12357
 *       loggingEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Message Notification Service Topic can be imported using the id or topic_name, e.g.
 * ```sh
 * $ pulumi import alicloud:message/serviceTopic:ServiceTopic example <topic_name>
 * ```
 */
public class ServiceTopic internal constructor(
    override val javaResource: com.pulumi.alicloud.message.ServiceTopic,
) : KotlinCustomResource(javaResource, ServiceTopicMapper) {
    /**
     * Specifies whether to enable the log management feature. Default value: false. Valid values:
     */
    public val loggingEnabled: Output<Boolean>?
        get() = javaResource.loggingEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum size of a message body that can be sent to the topic. Unit: bytes. Valid values: 1024-65536. Default value: 65536.
     */
    public val maxMessageSize: Output<Int>
        get() = javaResource.maxMessageSize().applyValue({ args0 -> args0 })

    /**
     * Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 255 characters.
     */
    public val topicName: Output<String>
        get() = javaResource.topicName().applyValue({ args0 -> args0 })
}

public object ServiceTopicMapper : ResourceMapper<ServiceTopic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.message.ServiceTopic::class == javaResource::class

    override fun map(javaResource: Resource): ServiceTopic = ServiceTopic(
        javaResource as
            com.pulumi.alicloud.message.ServiceTopic,
    )
}

/**
 * @see [ServiceTopic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceTopic].
 */
public suspend fun serviceTopic(
    name: String,
    block: suspend ServiceTopicResourceBuilder.() -> Unit,
): ServiceTopic {
    val builder = ServiceTopicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceTopic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceTopic(name: String): ServiceTopic {
    val builder = ServiceTopicResourceBuilder()
    builder.name(name)
    return builder.build()
}
