@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin

import com.pulumi.alicloud.message.ServiceTopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Message Notification Service Topic resource.
 * For information about Message Notification Service Topic and how to use it, see [What is Topic](https://www.alibabacloud.com/help/en/message-service/latest/createtopic).
 * > **NOTE:** Available since v1.188.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new alicloud.message.ServiceTopic("default", {
 *     topicName: name,
 *     maxMessageSize: 12357,
 *     loggingEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.message.ServiceTopic("default",
 *     topic_name=name,
 *     max_message_size=12357,
 *     logging_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new AliCloud.Message.ServiceTopic("default", new()
 *     {
 *         TopicName = name,
 *         MaxMessageSize = 12357,
 *         LoggingEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/message"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := message.NewServiceTopic(ctx, "default", &message.ServiceTopicArgs{
 * 			TopicName:      pulumi.String(name),
 * 			MaxMessageSize: pulumi.Int(12357),
 * 			LoggingEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.message.ServiceTopic;
 * import com.pulumi.alicloud.message.ServiceTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new ServiceTopic("default", ServiceTopicArgs.builder()
 *             .topicName(name)
 *             .maxMessageSize(12357)
 *             .loggingEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: alicloud:message:ServiceTopic
 *     properties:
 *       topicName: ${name}
 *       maxMessageSize: 12357
 *       loggingEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Message Notification Service Topic can be imported using the id or topic_name, e.g.
 * ```sh
 * $ pulumi import alicloud:message/serviceTopic:ServiceTopic example <topic_name>
 * ```
 * @property loggingEnabled Specifies whether to enable the log management feature. Default value: false. Valid values:
 * @property maxMessageSize The maximum size of a message body that can be sent to the topic. Unit: bytes. Valid values: 1024-65536. Default value: 65536.
 * @property topicName Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 255 characters.
 */
public data class ServiceTopicArgs(
    public val loggingEnabled: Output<Boolean>? = null,
    public val maxMessageSize: Output<Int>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.message.ServiceTopicArgs> {
    override fun toJava(): com.pulumi.alicloud.message.ServiceTopicArgs =
        com.pulumi.alicloud.message.ServiceTopicArgs.builder()
            .loggingEnabled(loggingEnabled?.applyValue({ args0 -> args0 }))
            .maxMessageSize(maxMessageSize?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceTopicArgs].
 */
@PulumiTagMarker
public class ServiceTopicArgsBuilder internal constructor() {
    private var loggingEnabled: Output<Boolean>? = null

    private var maxMessageSize: Output<Int>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value Specifies whether to enable the log management feature. Default value: false. Valid values:
     */
    @JvmName("hmfcqccdxejfqdho")
    public suspend fun loggingEnabled(`value`: Output<Boolean>) {
        this.loggingEnabled = value
    }

    /**
     * @param value The maximum size of a message body that can be sent to the topic. Unit: bytes. Valid values: 1024-65536. Default value: 65536.
     */
    @JvmName("pgxyarueuqicuotu")
    public suspend fun maxMessageSize(`value`: Output<Int>) {
        this.maxMessageSize = value
    }

    /**
     * @param value Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 255 characters.
     */
    @JvmName("wkhstlohnqtuqtbv")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value Specifies whether to enable the log management feature. Default value: false. Valid values:
     */
    @JvmName("bodsvwxdpjhvwpkk")
    public suspend fun loggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingEnabled = mapped
    }

    /**
     * @param value The maximum size of a message body that can be sent to the topic. Unit: bytes. Valid values: 1024-65536. Default value: 65536.
     */
    @JvmName("bwujgkcqprnpqfyl")
    public suspend fun maxMessageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxMessageSize = mapped
    }

    /**
     * @param value Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 255 characters.
     */
    @JvmName("ukfmklnxybxfkxfj")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): ServiceTopicArgs = ServiceTopicArgs(
        loggingEnabled = loggingEnabled,
        maxMessageSize = maxMessageSize,
        topicName = topicName,
    )
}
