@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.inputs

import com.pulumi.alicloud.message.inputs.GetServiceQueuesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceQueues.
 * @property ids A list of Queue IDs. Its element value is same as Queue Name.
 * @property nameRegex A regex string to filter results by Queue name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property queueName The name of the queue.
 */
public data class GetServiceQueuesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val queueName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.message.inputs.GetServiceQueuesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.message.inputs.GetServiceQueuesPlainArgs =
        com.pulumi.alicloud.message.inputs.GetServiceQueuesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .queueName(queueName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceQueuesPlainArgs].
 */
@PulumiTagMarker
public class GetServiceQueuesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var queueName: String? = null

    /**
     * @param value A list of Queue IDs. Its element value is same as Queue Name.
     */
    @JvmName("ibjkwdogupolxvjp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Queue IDs. Its element value is same as Queue Name.
     */
    @JvmName("uqjekvbbnymcsaor")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Queue name.
     */
    @JvmName("tcghjaahjhrlscqk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bcjwrvybtkxtovxc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("grqjhmnmvlvdkqvw")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ceyjrtmsxgeftiar")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The name of the queue.
     */
    @JvmName("dmpdgtkaxyfbiora")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queueName = mapped
    }

    internal fun build(): GetServiceQueuesPlainArgs = GetServiceQueuesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        queueName = queueName,
    )
}
