@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.inputs

import com.pulumi.alicloud.message.inputs.GetServiceSubscriptionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceSubscriptions.
 * @property ids A list of Subscription IDs.
 * @property nameRegex A regex string to filter results by Subscription name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property subscriptionName The name of the subscription.
 * @property topicName The name of the topic.
 */
public data class GetServiceSubscriptionsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val subscriptionName: String? = null,
    public val topicName: String,
) : ConvertibleToJava<com.pulumi.alicloud.message.inputs.GetServiceSubscriptionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.message.inputs.GetServiceSubscriptionsPlainArgs =
        com.pulumi.alicloud.message.inputs.GetServiceSubscriptionsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .subscriptionName(subscriptionName?.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceSubscriptionsPlainArgs].
 */
@PulumiTagMarker
public class GetServiceSubscriptionsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var subscriptionName: String? = null

    private var topicName: String? = null

    /**
     * @param value A list of Subscription IDs.
     */
    @JvmName("sorslxcwppcclphg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Subscription IDs.
     */
    @JvmName("tbcsgppkplrlpnqg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Subscription name.
     */
    @JvmName("qxlhqgsxphawugju")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("upmlsgptsbhfovav")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ucrlrkdcqnkcdvrl")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("sovopnoavpwvuivu")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The name of the subscription.
     */
    @JvmName("orrkwdeutpyqxpdr")
    public suspend fun subscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionName = mapped
    }

    /**
     * @param value The name of the topic.
     */
    @JvmName("sadhigoqtxkpphfr")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetServiceSubscriptionsPlainArgs = GetServiceSubscriptionsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        subscriptionName = subscriptionName,
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
