@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.inputs

import com.pulumi.alicloud.message.inputs.GetServiceTopicsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceTopics.
 * @property ids A list of Topic IDs. Its element value is same as Topic Name.
 * @property nameRegex A regex string to filter results by Topic name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property topicName The name of the topic.
 */
public data class GetServiceTopicsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val topicName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.message.inputs.GetServiceTopicsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.message.inputs.GetServiceTopicsPlainArgs =
        com.pulumi.alicloud.message.inputs.GetServiceTopicsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .topicName(topicName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceTopicsPlainArgs].
 */
@PulumiTagMarker
public class GetServiceTopicsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var topicName: String? = null

    /**
     * @param value A list of Topic IDs. Its element value is same as Topic Name.
     */
    @JvmName("hubtdrrycncpaexl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Topic IDs. Its element value is same as Topic Name.
     */
    @JvmName("glwtfknmcanwseig")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Topic name.
     */
    @JvmName("icpsnjtvwwjbhybd")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vrhdtbqyahwqtimj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("pfllaktiutmmkhji")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("nojypmstuxkmrcdi")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The name of the topic.
     */
    @JvmName("arjblapdsdvdxkof")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetServiceTopicsPlainArgs = GetServiceTopicsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        topicName = topicName,
    )
}
