@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property activeMessages The total number of messages that are in the Active state in the queue. The value is an approximate number.
 * @property createTime The time when the queue was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
 * @property delayMessages The total number of the messages that are in the Delayed state in the queue. The value is an approximate number.
 * @property delaySeconds The delay period after which all messages that are sent to the queue can be consumed. Unit: seconds.
 * @property id The ID of the Queue. Its value is same as Queue Name.
 * @property inactiveMessages The total number of the messages that are in the Inactive state in the queue. The value is an approximate number.
 * @property lastModifyTime The time when the queue was last modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
 * @property loggingEnabled Indicates whether the log management feature is enabled for the queue.
 * @property maximumMessageSize The maximum size of a message body that can be sent to the queue. Unit: bytes.
 * @property messageRetentionPeriod The maximum period for which a message can be retained in the queue. A message that is sent to the queue can be retained for a specified period. After the specified period ends, the message is deleted no matter whether it is consumed. Unit: seconds.
 * @property pollingWaitSeconds The maximum period for which a ReceiveMessage request waits if no message is available in the queue. Unit: seconds.
 * @property queueInternalUrl The internal url of the queue.
 * @property queueName The name of the queue.
 * @property queueUrl The url of the queue.
 * @property visibilityTimeout The invisibility period for which the received message remains the Inactive state. Unit: seconds.
 */
public data class GetServiceQueuesQueue(
    public val activeMessages: Int,
    public val createTime: Int,
    public val delayMessages: Int,
    public val delaySeconds: Int,
    public val id: String,
    public val inactiveMessages: Int,
    public val lastModifyTime: Int,
    public val loggingEnabled: Boolean,
    public val maximumMessageSize: Int,
    public val messageRetentionPeriod: Int,
    public val pollingWaitSeconds: Int,
    public val queueInternalUrl: String,
    public val queueName: String,
    public val queueUrl: String,
    public val visibilityTimeout: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.message.outputs.GetServiceQueuesQueue): GetServiceQueuesQueue = GetServiceQueuesQueue(
            activeMessages = javaType.activeMessages(),
            createTime = javaType.createTime(),
            delayMessages = javaType.delayMessages(),
            delaySeconds = javaType.delaySeconds(),
            id = javaType.id(),
            inactiveMessages = javaType.inactiveMessages(),
            lastModifyTime = javaType.lastModifyTime(),
            loggingEnabled = javaType.loggingEnabled(),
            maximumMessageSize = javaType.maximumMessageSize(),
            messageRetentionPeriod = javaType.messageRetentionPeriod(),
            pollingWaitSeconds = javaType.pollingWaitSeconds(),
            queueInternalUrl = javaType.queueInternalUrl(),
            queueName = javaType.queueName(),
            queueUrl = javaType.queueUrl(),
            visibilityTimeout = javaType.visibilityTimeout(),
        )
    }
}
