@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServiceQueues.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Queue names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property queueName The name of the queue.
 * @property queues A list of Queues. Each element contains the following attributes:
 */
public data class GetServiceQueuesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val queueName: String? = null,
    public val queues: List<GetServiceQueuesQueue>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.message.outputs.GetServiceQueuesResult): GetServiceQueuesResult = GetServiceQueuesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            queueName = javaType.queueName().map({ args0 -> args0 }).orElse(null),
            queues = javaType.queues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.message.kotlin.outputs.GetServiceQueuesQueue.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
