@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServiceSubscriptions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Subscription names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property subscriptionName The name of the subscription.
 * @property subscriptions A list of Subscriptions. Each element contains the following attributes:
 * @property topicName The name of the topic.
 */
public data class GetServiceSubscriptionsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val subscriptionName: String? = null,
    public val subscriptions: List<GetServiceSubscriptionsSubscription>,
    public val topicName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.message.outputs.GetServiceSubscriptionsResult): GetServiceSubscriptionsResult = GetServiceSubscriptionsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            subscriptionName = javaType.subscriptionName().map({ args0 -> args0 }).orElse(null),
            subscriptions = javaType.subscriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.message.kotlin.outputs.GetServiceSubscriptionsSubscription.Companion.toKotlin(args0)
                })
            }),
            topicName = javaType.topicName(),
        )
    }
}
