@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when the subscription was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
 * @property endpoint The endpoint to which the messages are pushed.
 * @property filterTag The tag that is used to filter messages. Only the messages that are attached with the specified tag can be pushed.
 * @property id The id of the Subscription.
 * @property lastModifyTime The time when the subscription was last modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
 * @property notifyContentFormat The content format of the messages that are pushed to the endpoint.
 * @property notifyStrategy The retry policy that is applied if an error occurs when MNS pushes messages to the endpoint.
 * @property subscriptionName The name of the subscription.
 * @property subscriptionUrl The url of the subscription.
 * @property topicName The name of the topic.
 * @property topicOwner The account ID of the topic owner.
 */
public data class GetServiceSubscriptionsSubscription(
    public val createTime: Int,
    public val endpoint: String,
    public val filterTag: String,
    public val id: String,
    public val lastModifyTime: Int,
    public val notifyContentFormat: String,
    public val notifyStrategy: String,
    public val subscriptionName: String,
    public val subscriptionUrl: String,
    public val topicName: String,
    public val topicOwner: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.message.outputs.GetServiceSubscriptionsSubscription): GetServiceSubscriptionsSubscription = GetServiceSubscriptionsSubscription(
            createTime = javaType.createTime(),
            endpoint = javaType.endpoint(),
            filterTag = javaType.filterTag(),
            id = javaType.id(),
            lastModifyTime = javaType.lastModifyTime(),
            notifyContentFormat = javaType.notifyContentFormat(),
            notifyStrategy = javaType.notifyStrategy(),
            subscriptionName = javaType.subscriptionName(),
            subscriptionUrl = javaType.subscriptionUrl(),
            topicName = javaType.topicName(),
            topicOwner = javaType.topicOwner(),
        )
    }
}
