@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServiceTopics.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Topic names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property topicName The name of the topic.
 * @property topics A list of Topics. Each element contains the following attributes:
 */
public data class GetServiceTopicsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val topicName: String? = null,
    public val topics: List<GetServiceTopicsTopic>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.message.outputs.GetServiceTopicsResult): GetServiceTopicsResult = GetServiceTopicsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            topicName = javaType.topicName().map({ args0 -> args0 }).orElse(null),
            topics = javaType.topics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.message.kotlin.outputs.GetServiceTopicsTopic.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
