@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.message.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when the topic was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
 * @property id The id of the Topic. Its value is same as Topic Name.
 * @property lastModifyTime The time when the topic was last modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since the epoch time January 1, 1970, 00:00:00 UTC.
 * @property loggingEnabled Indicates whether the log management feature is enabled.
 * @property maxMessageSize The maximum size of a message body that can be sent to the topic. Unit: bytes.
 * @property messageCount The number of messages in the topic.
 * @property messageRetentionPeriod The maximum period for which a message can be retained in the topic. A message that is sent to the topic can be retained for a specified period. After the specified period ends, the message is deleted no matter whether it is pushed to the specified endpoints. Unit: seconds.
 * @property topicInnerUrl The inner url of the topic.
 * @property topicName The name of the topic.
 * @property topicUrl The url of the topic.
 */
public data class GetServiceTopicsTopic(
    public val createTime: Int,
    public val id: String,
    public val lastModifyTime: Int,
    public val loggingEnabled: Boolean,
    public val maxMessageSize: Int,
    public val messageCount: Int,
    public val messageRetentionPeriod: Int,
    public val topicInnerUrl: String,
    public val topicName: String,
    public val topicUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.message.outputs.GetServiceTopicsTopic): GetServiceTopicsTopic = GetServiceTopicsTopic(
            createTime = javaType.createTime(),
            id = javaType.id(),
            lastModifyTime = javaType.lastModifyTime(),
            loggingEnabled = javaType.loggingEnabled(),
            maxMessageSize = javaType.maxMessageSize(),
            messageCount = javaType.messageCount(),
            messageRetentionPeriod = javaType.messageRetentionPeriod(),
            topicInnerUrl = javaType.topicInnerUrl(),
            topicName = javaType.topicName(),
            topicUrl = javaType.topicUrl(),
        )
    }
}
