@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [App].
 */
@PulumiTagMarker
public class AppResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppArgs = AppArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppArgsBuilder.() -> Unit) {
        val builder = AppArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): App {
        val builtJavaResource = com.pulumi.alicloud.mhub.App(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return App(builtJavaResource)
    }
}

/**
 * Provides a MHUB App resource.
 * For information about MHUB App and how to use it, see [What is App](https://help.aliyun.com/product/65109.html).
 * > **NOTE:** Available since v1.138.0+.
 * > **NOTE:** At present, the resource only supports cn-shanghai region.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "example_value";
 * const _default = new alicloud.mhub.Product("default", {productName: name});
 * const defaultApp = new alicloud.mhub.App("default", {
 *     appName: name,
 *     productId: _default.id,
 *     packageName: "com.example.android",
 *     type: "Android",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "example_value"
 * default = alicloud.mhub.Product("default", product_name=name)
 * default_app = alicloud.mhub.App("default",
 *     app_name=name,
 *     product_id=default.id,
 *     package_name="com.example.android",
 *     type="Android")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "example_value";
 *     var @default = new AliCloud.Mhub.Product("default", new()
 *     {
 *         ProductName = name,
 *     });
 *     var defaultApp = new AliCloud.Mhub.App("default", new()
 *     {
 *         AppName = name,
 *         ProductId = @default.Id,
 *         PackageName = "com.example.android",
 *         Type = "Android",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "example_value"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := mhub.NewProduct(ctx, "default", &mhub.ProductArgs{
 * 			ProductName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mhub.NewApp(ctx, "default", &mhub.AppArgs{
 * 			AppName:     pulumi.String(name),
 * 			ProductId:   _default.ID(),
 * 			PackageName: pulumi.String("com.example.android"),
 * 			Type:        pulumi.String("Android"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mhub.Product;
 * import com.pulumi.alicloud.mhub.ProductArgs;
 * import com.pulumi.alicloud.mhub.App;
 * import com.pulumi.alicloud.mhub.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("example_value");
 *         var default_ = new Product("default", ProductArgs.builder()
 *             .productName(name)
 *             .build());
 *         var defaultApp = new App("defaultApp", AppArgs.builder()
 *             .appName(name)
 *             .productId(default_.id())
 *             .packageName("com.example.android")
 *             .type("Android")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: example_value
 * resources:
 *   default:
 *     type: alicloud:mhub:Product
 *     properties:
 *       productName: ${name}
 *   defaultApp:
 *     type: alicloud:mhub:App
 *     name: default
 *     properties:
 *       appName: ${name}
 *       productId: ${default.id}
 *       packageName: com.example.android
 *       type: Android
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MHUB App can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mhub/app:App example <product_id>:<app_key>
 * ```
 */
public class App internal constructor(
    override val javaResource: com.pulumi.alicloud.mhub.App,
) : KotlinCustomResource(javaResource, AppMapper) {
    /**
     * AppName.
     */
    public val appName: Output<String>
        get() = javaResource.appName().applyValue({ args0 -> args0 })

    /**
     * The app id of iOS. **NOTE:** Either `bundle_id` or `package_name` must be set.
     */
    public val bundleId: Output<String>?
        get() = javaResource.bundleId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Base64 string of picture.
     */
    public val encodedIcon: Output<String>?
        get() = javaResource.encodedIcon().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Industry ID of the app. For information about Industry and how to use it, MHUB[Industry](https://help.aliyun.com/document_detail/201638.html).
     */
    public val industryId: Output<String>
        get() = javaResource.industryId().applyValue({ args0 -> args0 })

    /**
     * Android App package name. **NOTE:** Either `bundle_id` or `package_name` must be set.
     */
    public val packageName: Output<String>?
        get() = javaResource.packageName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Product.
     */
    public val productId: Output<String>
        get() = javaResource.productId().applyValue({ args0 -> args0 })

    /**
     * The type of the Product. Valid values: `Android` and `iOS`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppMapper : ResourceMapper<App> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mhub.App::class == javaResource::class

    override fun map(javaResource: Resource): App = App(javaResource as com.pulumi.alicloud.mhub.App)
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [App].
 */
public suspend fun app(name: String, block: suspend AppResourceBuilder.() -> Unit): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 */
public fun app(name: String): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    return builder.build()
}
