@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mhub.kotlin

import com.pulumi.alicloud.mhub.AppArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a MHUB App resource.
 * For information about MHUB App and how to use it, see [What is App](https://help.aliyun.com/product/65109.html).
 * > **NOTE:** Available since v1.138.0+.
 * > **NOTE:** At present, the resource only supports cn-shanghai region.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "example_value";
 * const _default = new alicloud.mhub.Product("default", {productName: name});
 * const defaultApp = new alicloud.mhub.App("default", {
 *     appName: name,
 *     productId: _default.id,
 *     packageName: "com.example.android",
 *     type: "Android",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "example_value"
 * default = alicloud.mhub.Product("default", product_name=name)
 * default_app = alicloud.mhub.App("default",
 *     app_name=name,
 *     product_id=default.id,
 *     package_name="com.example.android",
 *     type="Android")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "example_value";
 *     var @default = new AliCloud.Mhub.Product("default", new()
 *     {
 *         ProductName = name,
 *     });
 *     var defaultApp = new AliCloud.Mhub.App("default", new()
 *     {
 *         AppName = name,
 *         ProductId = @default.Id,
 *         PackageName = "com.example.android",
 *         Type = "Android",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "example_value"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := mhub.NewProduct(ctx, "default", &mhub.ProductArgs{
 * 			ProductName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mhub.NewApp(ctx, "default", &mhub.AppArgs{
 * 			AppName:     pulumi.String(name),
 * 			ProductId:   _default.ID(),
 * 			PackageName: pulumi.String("com.example.android"),
 * 			Type:        pulumi.String("Android"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mhub.Product;
 * import com.pulumi.alicloud.mhub.ProductArgs;
 * import com.pulumi.alicloud.mhub.App;
 * import com.pulumi.alicloud.mhub.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("example_value");
 *         var default_ = new Product("default", ProductArgs.builder()
 *             .productName(name)
 *             .build());
 *         var defaultApp = new App("defaultApp", AppArgs.builder()
 *             .appName(name)
 *             .productId(default_.id())
 *             .packageName("com.example.android")
 *             .type("Android")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: example_value
 * resources:
 *   default:
 *     type: alicloud:mhub:Product
 *     properties:
 *       productName: ${name}
 *   defaultApp:
 *     type: alicloud:mhub:App
 *     name: default
 *     properties:
 *       appName: ${name}
 *       productId: ${default.id}
 *       packageName: com.example.android
 *       type: Android
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MHUB App can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mhub/app:App example <product_id>:<app_key>
 * ```
 * @property appName AppName.
 * @property bundleId The app id of iOS. **NOTE:** Either `bundle_id` or `package_name` must be set.
 * @property encodedIcon Base64 string of picture.
 * @property industryId The Industry ID of the app. For information about Industry and how to use it, MHUB[Industry](https://help.aliyun.com/document_detail/201638.html).
 * @property packageName Android App package name. **NOTE:** Either `bundle_id` or `package_name` must be set.
 * @property productId The ID of the Product.
 * @property type The type of the Product. Valid values: `Android` and `iOS`.
 */
public data class AppArgs(
    public val appName: Output<String>? = null,
    public val bundleId: Output<String>? = null,
    public val encodedIcon: Output<String>? = null,
    public val industryId: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mhub.AppArgs> {
    override fun toJava(): com.pulumi.alicloud.mhub.AppArgs =
        com.pulumi.alicloud.mhub.AppArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .encodedIcon(encodedIcon?.applyValue({ args0 -> args0 }))
            .industryId(industryId?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppArgs].
 */
@PulumiTagMarker
public class AppArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var bundleId: Output<String>? = null

    private var encodedIcon: Output<String>? = null

    private var industryId: Output<String>? = null

    private var packageName: Output<String>? = null

    private var productId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value AppName.
     */
    @JvmName("wtdiaaabcjjwault")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The app id of iOS. **NOTE:** Either `bundle_id` or `package_name` must be set.
     */
    @JvmName("jakbpkhatungoeen")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value Base64 string of picture.
     */
    @JvmName("wggxjbwyoiirgntp")
    public suspend fun encodedIcon(`value`: Output<String>) {
        this.encodedIcon = value
    }

    /**
     * @param value The Industry ID of the app. For information about Industry and how to use it, MHUB[Industry](https://help.aliyun.com/document_detail/201638.html).
     */
    @JvmName("wtjvvqomtvwbtbag")
    public suspend fun industryId(`value`: Output<String>) {
        this.industryId = value
    }

    /**
     * @param value Android App package name. **NOTE:** Either `bundle_id` or `package_name` must be set.
     */
    @JvmName("hafleynsdnobqsrp")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value The ID of the Product.
     */
    @JvmName("bfyifqqpikqmgxcu")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value The type of the Product. Valid values: `Android` and `iOS`.
     */
    @JvmName("gupnhvlgdsolsrul")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value AppName.
     */
    @JvmName("yoelwnctjohjowmd")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The app id of iOS. **NOTE:** Either `bundle_id` or `package_name` must be set.
     */
    @JvmName("qlecicsybgsigiuf")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value Base64 string of picture.
     */
    @JvmName("ndhxqmyettderiss")
    public suspend fun encodedIcon(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedIcon = mapped
    }

    /**
     * @param value The Industry ID of the app. For information about Industry and how to use it, MHUB[Industry](https://help.aliyun.com/document_detail/201638.html).
     */
    @JvmName("ghgbgdnmcbhxttuh")
    public suspend fun industryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.industryId = mapped
    }

    /**
     * @param value Android App package name. **NOTE:** Either `bundle_id` or `package_name` must be set.
     */
    @JvmName("dcavadpwggsqahwp")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value The ID of the Product.
     */
    @JvmName("lqrxhjggfbjswydq")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value The type of the Product. Valid values: `Android` and `iOS`.
     */
    @JvmName("qsbsrugkjngauofm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AppArgs = AppArgs(
        appName = appName,
        bundleId = bundleId,
        encodedIcon = encodedIcon,
        industryId = industryId,
        packageName = packageName,
        productId = productId,
        type = type,
    )
}
