@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mhub.kotlin

import com.pulumi.alicloud.mhub.MhubFunctions.getAppsPlain
import com.pulumi.alicloud.mhub.MhubFunctions.getProductsPlain
import com.pulumi.alicloud.mhub.kotlin.inputs.GetAppsPlainArgs
import com.pulumi.alicloud.mhub.kotlin.inputs.GetAppsPlainArgsBuilder
import com.pulumi.alicloud.mhub.kotlin.inputs.GetProductsPlainArgs
import com.pulumi.alicloud.mhub.kotlin.inputs.GetProductsPlainArgsBuilder
import com.pulumi.alicloud.mhub.kotlin.outputs.GetAppsResult
import com.pulumi.alicloud.mhub.kotlin.outputs.GetProductsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.mhub.kotlin.outputs.GetAppsResult.Companion.toKotlin as getAppsResultToKotlin
import com.pulumi.alicloud.mhub.kotlin.outputs.GetProductsResult.Companion.toKotlin as getProductsResultToKotlin

public object MhubFunctions {
    /**
     * This data source provides the Mhub Apps of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.138.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "example_value";
     * const _default = new alicloud.mhub.App("default", {
     *     appName: name,
     *     productId: defaultAlicloudMhubProduct.id,
     *     packageName: "com.test.android",
     *     type: "2",
     * });
     * const ids = alicloud.mhub.getApps({});
     * export const mhubAppId1 = ids.then(ids => ids.apps?.[0]?.id);
     * const nameRegex = alicloud.mhub.getApps({
     *     nameRegex: "^my-App",
     * });
     * export const mhubAppId2 = nameRegex.then(nameRegex => nameRegex.apps?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "example_value"
     * default = alicloud.mhub.App("default",
     *     app_name=name,
     *     product_id=default_alicloud_mhub_product["id"],
     *     package_name="com.test.android",
     *     type="2")
     * ids = alicloud.mhub.get_apps()
     * pulumi.export("mhubAppId1", ids.apps[0].id)
     * name_regex = alicloud.mhub.get_apps(name_regex="^my-App")
     * pulumi.export("mhubAppId2", name_regex.apps[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "example_value";
     *     var @default = new AliCloud.Mhub.App("default", new()
     *     {
     *         AppName = name,
     *         ProductId = defaultAlicloudMhubProduct.Id,
     *         PackageName = "com.test.android",
     *         Type = "2",
     *     });
     *     var ids = AliCloud.Mhub.GetApps.Invoke();
     *     var nameRegex = AliCloud.Mhub.GetApps.Invoke(new()
     *     {
     *         NameRegex = "^my-App",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mhubAppId1"] = ids&#46;Apply(getAppsResult => getAppsResult&#46;Apps[0]?.Id),
     *         ["mhubAppId2"] = nameRegex&#46;Apply(getAppsResult => getAppsResult&#46;Apps[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mhub"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "example_value"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_, err := mhub.NewApp(ctx, "default", &mhub.AppArgs{
     * 			AppName:     pulumi.String(name),
     * 			ProductId:   pulumi.Any(defaultAlicloudMhubProduct.Id),
     * 			PackageName: pulumi.String("com.test.android"),
     * 			Type:        pulumi.String("2"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids, err := mhub.GetApps(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mhubAppId1", ids.Apps[0].Id)
     * 		nameRegex, err := mhub.GetApps(ctx, &mhub.GetAppsArgs{
     * 			NameRegex: pulumi.StringRef("^my-App"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mhubAppId2", nameRegex.Apps[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mhub.App;
     * import com.pulumi.alicloud.mhub.AppArgs;
     * import com.pulumi.alicloud.mhub.MhubFunctions;
     * import com.pulumi.alicloud.mhub.inputs.GetAppsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("example_value");
     *         var default_ = new App("default", AppArgs.builder()
     *             .appName(name)
     *             .productId(defaultAlicloudMhubProduct.id())
     *             .packageName("com.test.android")
     *             .type("2")
     *             .build());
     *         final var ids = MhubFunctions.getApps();
     *         ctx.export("mhubAppId1", ids.applyValue(getAppsResult -> getAppsResult.apps()[0].id()));
     *         final var nameRegex = MhubFunctions.getApps(GetAppsArgs.builder()
     *             .nameRegex("^my-App")
     *             .build());
     *         ctx.export("mhubAppId2", nameRegex.applyValue(getAppsResult -> getAppsResult.apps()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: example_value
     * resources:
     *   default:
     *     type: alicloud:mhub:App
     *     properties:
     *       appName: ${name}
     *       productId: ${defaultAlicloudMhubProduct.id}
     *       packageName: com.test.android
     *       type: '2'
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:mhub:getApps
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:mhub:getApps
     *       Arguments:
     *         nameRegex: ^my-App
     * outputs:
     *   mhubAppId1: ${ids.apps[0].id}
     *   mhubAppId2: ${nameRegex.apps[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApps.
     * @return A collection of values returned by getApps.
     */
    public suspend fun getApps(argument: GetAppsPlainArgs): GetAppsResult =
        getAppsResultToKotlin(getAppsPlain(argument.toJava()).await())

    /**
     * @see [getApps].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of App IDs. The value formats as `<product_id>:<app_key>`
     * @param nameRegex A regex string to filter results by App name.
     * @param osType The os type. Valid values: `Android` and `iOS`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productId The ID of the Product.
     * @return A collection of values returned by getApps.
     */
    public suspend fun getApps(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        osType: String? = null,
        outputFile: String? = null,
        productId: String,
    ): GetAppsResult {
        val argument = GetAppsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            osType = osType,
            outputFile = outputFile,
            productId = productId,
        )
        return getAppsResultToKotlin(getAppsPlain(argument.toJava()).await())
    }

    /**
     * @see [getApps].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mhub&#46;kotlin&#46;inputs&#46;GetAppsPlainArgs].
     * @return A collection of values returned by getApps.
     */
    public suspend fun getApps(argument: suspend GetAppsPlainArgsBuilder.() -> Unit): GetAppsResult {
        val builder = GetAppsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppsResultToKotlin(getAppsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Mhub Products of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.138.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "example_value";
     * const _default = new alicloud.mhub.Product("default", {productName: name});
     * const ids = alicloud.mhub.getProducts({});
     * export const mhubProductId1 = ids.then(ids => ids.products?.[0]?.id);
     * const nameRegex = alicloud.mhub.getProducts({
     *     nameRegex: "^my-Product",
     * });
     * export const mhubProductId2 = nameRegex.then(nameRegex => nameRegex.products?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "example_value"
     * default = alicloud.mhub.Product("default", product_name=name)
     * ids = alicloud.mhub.get_products()
     * pulumi.export("mhubProductId1", ids.products[0].id)
     * name_regex = alicloud.mhub.get_products(name_regex="^my-Product")
     * pulumi.export("mhubProductId2", name_regex.products[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "example_value";
     *     var @default = new AliCloud.Mhub.Product("default", new()
     *     {
     *         ProductName = name,
     *     });
     *     var ids = AliCloud.Mhub.GetProducts.Invoke();
     *     var nameRegex = AliCloud.Mhub.GetProducts.Invoke(new()
     *     {
     *         NameRegex = "^my-Product",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mhubProductId1"] = ids&#46;Apply(getProductsResult => getProductsResult&#46;Products[0]?.Id),
     *         ["mhubProductId2"] = nameRegex&#46;Apply(getProductsResult => getProductsResult&#46;Products[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mhub"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "example_value"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_, err := mhub.NewProduct(ctx, "default", &mhub.ProductArgs{
     * 			ProductName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids, err := mhub.GetProducts(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mhubProductId1", ids.Products[0].Id)
     * 		nameRegex, err := mhub.GetProducts(ctx, &mhub.GetProductsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Product"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mhubProductId2", nameRegex.Products[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mhub.Product;
     * import com.pulumi.alicloud.mhub.ProductArgs;
     * import com.pulumi.alicloud.mhub.MhubFunctions;
     * import com.pulumi.alicloud.mhub.inputs.GetProductsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("example_value");
     *         var default_ = new Product("default", ProductArgs.builder()
     *             .productName(name)
     *             .build());
     *         final var ids = MhubFunctions.getProducts();
     *         ctx.export("mhubProductId1", ids.applyValue(getProductsResult -> getProductsResult.products()[0].id()));
     *         final var nameRegex = MhubFunctions.getProducts(GetProductsArgs.builder()
     *             .nameRegex("^my-Product")
     *             .build());
     *         ctx.export("mhubProductId2", nameRegex.applyValue(getProductsResult -> getProductsResult.products()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: example_value
     * resources:
     *   default:
     *     type: alicloud:mhub:Product
     *     properties:
     *       productName: ${name}
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:mhub:getProducts
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:mhub:getProducts
     *       Arguments:
     *         nameRegex: ^my-Product
     * outputs:
     *   mhubProductId1: ${ids.products[0].id}
     *   mhubProductId2: ${nameRegex.products[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProducts.
     * @return A collection of values returned by getProducts.
     */
    public suspend fun getProducts(argument: GetProductsPlainArgs): GetProductsResult =
        getProductsResultToKotlin(getProductsPlain(argument.toJava()).await())

    /**
     * @see [getProducts].
     * @param ids A list of Product IDs.
     * @param nameRegex A regex string to filter results by Product name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getProducts.
     */
    public suspend fun getProducts(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetProductsResult {
        val argument = GetProductsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getProductsResultToKotlin(getProductsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProducts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mhub&#46;kotlin&#46;inputs&#46;GetProductsPlainArgs].
     * @return A collection of values returned by getProducts.
     */
    public suspend fun getProducts(argument: suspend GetProductsPlainArgsBuilder.() -> Unit): GetProductsResult {
        val builder = GetProductsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductsResultToKotlin(getProductsPlain(builtArgument.toJava()).await())
    }
}
