@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Product].
 */
@PulumiTagMarker
public class ProductResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductArgs = ProductArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductArgsBuilder.() -> Unit) {
        val builder = ProductArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Product {
        val builtJavaResource = com.pulumi.alicloud.mhub.Product(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Product(builtJavaResource)
    }
}

/**
 * Provides a MHUB Product resource.
 * For information about MHUB Product and how to use it, see [What is Product](https://help.aliyun.com/product/65109.html).
 * > **NOTE:** Available since v1.138.0+.
 * > **NOTE:** At present, the resource only supports cn-shanghai region.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.mhub.Product("example", {productName: "example_value"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.mhub.Product("example", product_name="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Mhub.Product("example", new()
 *     {
 *         ProductName = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mhub.NewProduct(ctx, "example", &mhub.ProductArgs{
 * 			ProductName: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mhub.Product;
 * import com.pulumi.alicloud.mhub.ProductArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Product("example", ProductArgs.builder()
 *             .productName("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:mhub:Product
 *     properties:
 *       productName: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MHUB Product can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mhub/product:Product example <id>
 * ```
 */
public class Product internal constructor(
    override val javaResource: com.pulumi.alicloud.mhub.Product,
) : KotlinCustomResource(javaResource, ProductMapper) {
    /**
     * ProductName.
     */
    public val productName: Output<String>
        get() = javaResource.productName().applyValue({ args0 -> args0 })
}

public object ProductMapper : ResourceMapper<Product> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mhub.Product::class == javaResource::class

    override fun map(javaResource: Resource): Product = Product(
        javaResource as
            com.pulumi.alicloud.mhub.Product,
    )
}

/**
 * @see [Product].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Product].
 */
public suspend fun product(name: String, block: suspend ProductResourceBuilder.() -> Unit): Product {
    val builder = ProductResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Product].
 * @param name The _unique_ name of the resulting resource.
 */
public fun product(name: String): Product {
    val builder = ProductResourceBuilder()
    builder.name(name)
    return builder.build()
}
