@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mhub.kotlin.inputs

import com.pulumi.alicloud.mhub.inputs.GetAppsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApps.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of App IDs. The value formats as `<product_id>:<app_key>`
 * @property nameRegex A regex string to filter results by App name.
 * @property osType The os type. Valid values: `Android` and `iOS`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productId The ID of the Product.
 */
public data class GetAppsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val osType: String? = null,
    public val outputFile: String? = null,
    public val productId: String,
) : ConvertibleToJava<com.pulumi.alicloud.mhub.inputs.GetAppsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mhub.inputs.GetAppsPlainArgs =
        com.pulumi.alicloud.mhub.inputs.GetAppsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .osType(osType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productId(productId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppsPlainArgs].
 */
@PulumiTagMarker
public class GetAppsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var osType: String? = null

    private var outputFile: String? = null

    private var productId: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("xginvdfrtlwfiiys")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of App IDs. The value formats as `<product_id>:<app_key>`
     */
    @JvmName("wlyljcswfxethcoc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of App IDs. The value formats as `<product_id>:<app_key>`
     */
    @JvmName("ponrptnfecfwdcnj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by App name.
     */
    @JvmName("fhfgxcvgsfmqrfrk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The os type. Valid values: `Android` and `iOS`.
     */
    @JvmName("kqfktnruycihbtkt")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.osType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dybjqfhqoacarjck")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the Product.
     */
    @JvmName("yhnxhrfraumlhfeg")
    public suspend fun productId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productId = mapped
    }

    internal fun build(): GetAppsPlainArgs = GetAppsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        osType = osType,
        outputFile = outputFile,
        productId = productId ?: throw PulumiNullFieldException("productId"),
    )
}
