@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appKey Application AppKey, which uniquely identifies an application when requested by the interface
 * @property appName The Name of the App.
 * @property bundleId iOS application ID. Required when creating an iOS app. **NOTE:** Either `bundle_id` or `package_name` must be set.
 * @property createTime The CreateTime of the App.
 * @property encodedIcon Base64 string of picture.
 * @property id The ID of the App.
 * @property industryId The Industry ID of the app. For information about Industry and how to use it, MHUB[Industry](https://help.aliyun.com/document_detail/201638.html).
 * @property packageName Android App package name.  **NOTE:** Either `bundle_id` or `package_name` must be set.
 * @property productId The ID of the Product.
 * @property type The type of the App. Valid values: `Android` and `iOS`.
 */
public data class GetAppsApp(
    public val appKey: String,
    public val appName: String,
    public val bundleId: String,
    public val createTime: String,
    public val encodedIcon: String,
    public val id: String,
    public val industryId: String,
    public val packageName: String,
    public val productId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mhub.outputs.GetAppsApp): GetAppsApp =
            GetAppsApp(
                appKey = javaType.appKey(),
                appName = javaType.appName(),
                bundleId = javaType.bundleId(),
                createTime = javaType.createTime(),
                encodedIcon = javaType.encodedIcon(),
                id = javaType.id(),
                industryId = javaType.industryId(),
                packageName = javaType.packageName(),
                productId = javaType.productId(),
                type = javaType.type(),
            )
    }
}
