@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mhub.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getApps.
 * @property apps
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property osType
 * @property outputFile
 * @property productId
 */
public data class GetAppsResult(
    public val apps: List<GetAppsApp>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val osType: String? = null,
    public val outputFile: String? = null,
    public val productId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mhub.outputs.GetAppsResult): GetAppsResult =
            GetAppsResult(
                apps = javaType.apps().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.mhub.kotlin.outputs.GetAppsApp.Companion.toKotlin(args0)
                    })
                }),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                productId = javaType.productId(),
            )
    }
}
