@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin

import com.pulumi.alicloud.mns.MnsFunctions.getQueuesPlain
import com.pulumi.alicloud.mns.MnsFunctions.getServicePlain
import com.pulumi.alicloud.mns.MnsFunctions.getTopicSubscriptionsPlain
import com.pulumi.alicloud.mns.MnsFunctions.getTopicsPlain
import com.pulumi.alicloud.mns.kotlin.inputs.GetQueuesPlainArgs
import com.pulumi.alicloud.mns.kotlin.inputs.GetQueuesPlainArgsBuilder
import com.pulumi.alicloud.mns.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.mns.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.mns.kotlin.inputs.GetTopicSubscriptionsPlainArgs
import com.pulumi.alicloud.mns.kotlin.inputs.GetTopicSubscriptionsPlainArgsBuilder
import com.pulumi.alicloud.mns.kotlin.inputs.GetTopicsPlainArgs
import com.pulumi.alicloud.mns.kotlin.inputs.GetTopicsPlainArgsBuilder
import com.pulumi.alicloud.mns.kotlin.outputs.GetQueuesResult
import com.pulumi.alicloud.mns.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.mns.kotlin.outputs.GetTopicSubscriptionsResult
import com.pulumi.alicloud.mns.kotlin.outputs.GetTopicsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.alicloud.mns.kotlin.outputs.GetQueuesResult.Companion.toKotlin as getQueuesResultToKotlin
import com.pulumi.alicloud.mns.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.mns.kotlin.outputs.GetTopicSubscriptionsResult.Companion.toKotlin as getTopicSubscriptionsResultToKotlin
import com.pulumi.alicloud.mns.kotlin.outputs.GetTopicsResult.Companion.toKotlin as getTopicsResultToKotlin

public object MnsFunctions {
    /**
     * This data source provides a list of MNS queues in an Alibaba Cloud account according to the specified parameters.
     * > **DEPRECATED:**  This datasource has been deprecated from version `1.188.0`. Please use new datasource message_service_queues.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const queues = alicloud.mns.getQueues({
     *     namePrefix: "tf-",
     * });
     * export const firstQueueId = queues.then(queues => queues.queues?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * queues = alicloud.mns.get_queues(name_prefix="tf-")
     * pulumi.export("firstQueueId", queues.queues[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var queues = AliCloud.Mns.GetQueues.Invoke(new()
     *     {
     *         NamePrefix = "tf-",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstQueueId"] = queues&#46;Apply(getQueuesResult => getQueuesResult&#46;Queues[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		queues, err := mns.GetQueues(ctx, &mns.GetQueuesArgs{
     * 			NamePrefix: pulumi.StringRef("tf-"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstQueueId", queues.Queues[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mns.MnsFunctions;
     * import com.pulumi.alicloud.mns.inputs.GetQueuesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var queues = MnsFunctions.getQueues(GetQueuesArgs.builder()
     *             .namePrefix("tf-")
     *             .build());
     *         ctx.export("firstQueueId", queues.applyValue(getQueuesResult -> getQueuesResult.queues()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   queues:
     *     fn::invoke:
     *       Function: alicloud:mns:getQueues
     *       Arguments:
     *         namePrefix: tf-
     * outputs:
     *   firstQueueId: ${queues.queues[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQueues.
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(argument: GetQueuesPlainArgs): GetQueuesResult =
        getQueuesResultToKotlin(getQueuesPlain(argument.toJava()).await())

    /**
     * @see [getQueues].
     * @param namePrefix A string to filter resulting queues by their name prefixs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(namePrefix: String? = null, outputFile: String? = null): GetQueuesResult {
        val argument = GetQueuesPlainArgs(
            namePrefix = namePrefix,
            outputFile = outputFile,
        )
        return getQueuesResultToKotlin(getQueuesPlain(argument.toJava()).await())
    }

    /**
     * @see [getQueues].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mns&#46;kotlin&#46;inputs&#46;GetQueuesPlainArgs].
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(argument: suspend GetQueuesPlainArgsBuilder.() -> Unit): GetQueuesResult {
        val builder = GetQueuesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueuesResultToKotlin(getQueuesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open MNS service automatically. If the service has been opened, it will return opened.
     * For information about MNS and how to use it, see [What is MNS](https://www.alibabacloud.com/help/en/product/27412.htm).
     * > **NOTE:** Available in v1.118.0+
     * > **NOTE:** The MNS service is not support in the international site.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.mns.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.mns.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Mns.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := mns.GetService(ctx, &mns.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mns.MnsFunctions;
     * import com.pulumi.alicloud.mns.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = MnsFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:mns:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the MNS service that means you have read and agreed the [MNS Terms of Service](https://help.aliyun.com/document_detail/27418.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mns&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of MNS topic subscriptions in an Alibaba Cloud account according to the specified parameters.
     * > **DEPRECATED:**  This datasource has been deprecated from version `1.188.0`. Please use new datasource message_service_subscriptions.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const subscriptions = alicloud.mns.getTopicSubscriptions({
     *     topicName: "topic_name",
     *     namePrefix: "tf-",
     * });
     * export const firstTopicSubscriptionId = subscriptions.then(subscriptions => subscriptions.subscriptions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * subscriptions = alicloud.mns.get_topic_subscriptions(topic_name="topic_name",
     *     name_prefix="tf-")
     * pulumi.export("firstTopicSubscriptionId", subscriptions.subscriptions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var subscriptions = AliCloud.Mns.GetTopicSubscriptions.Invoke(new()
     *     {
     *         TopicName = "topic_name",
     *         NamePrefix = "tf-",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTopicSubscriptionId"] = subscriptions&#46;Apply(getTopicSubscriptionsResult => getTopicSubscriptionsResult&#46;Subscriptions[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		subscriptions, err := mns.GetTopicSubscriptions(ctx, &mns.GetTopicSubscriptionsArgs{
     * 			TopicName:  "topic_name",
     * 			NamePrefix: pulumi.StringRef("tf-"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTopicSubscriptionId", subscriptions.Subscriptions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mns.MnsFunctions;
     * import com.pulumi.alicloud.mns.inputs.GetTopicSubscriptionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var subscriptions = MnsFunctions.getTopicSubscriptions(GetTopicSubscriptionsArgs.builder()
     *             .topicName("topic_name")
     *             .namePrefix("tf-")
     *             .build());
     *         ctx.export("firstTopicSubscriptionId", subscriptions.applyValue(getTopicSubscriptionsResult -> getTopicSubscriptionsResult.subscriptions()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   subscriptions:
     *     fn::invoke:
     *       Function: alicloud:mns:getTopicSubscriptions
     *       Arguments:
     *         topicName: topic_name
     *         namePrefix: tf-
     * outputs:
     *   firstTopicSubscriptionId: ${subscriptions.subscriptions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTopicSubscriptions.
     * @return A collection of values returned by getTopicSubscriptions.
     */
    public suspend fun getTopicSubscriptions(argument: GetTopicSubscriptionsPlainArgs): GetTopicSubscriptionsResult =
        getTopicSubscriptionsResultToKotlin(getTopicSubscriptionsPlain(argument.toJava()).await())

    /**
     * @see [getTopicSubscriptions].
     * @param namePrefix A string to filter resulting subscriptions of the topic by their name prefixs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param topicName Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     * @return A collection of values returned by getTopicSubscriptions.
     */
    public suspend fun getTopicSubscriptions(
        namePrefix: String? = null,
        outputFile: String? = null,
        topicName: String,
    ): GetTopicSubscriptionsResult {
        val argument = GetTopicSubscriptionsPlainArgs(
            namePrefix = namePrefix,
            outputFile = outputFile,
            topicName = topicName,
        )
        return getTopicSubscriptionsResultToKotlin(getTopicSubscriptionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopicSubscriptions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mns&#46;kotlin&#46;inputs&#46;GetTopicSubscriptionsPlainArgs].
     * @return A collection of values returned by getTopicSubscriptions.
     */
    public suspend fun getTopicSubscriptions(argument: suspend GetTopicSubscriptionsPlainArgsBuilder.() -> Unit): GetTopicSubscriptionsResult {
        val builder = GetTopicSubscriptionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicSubscriptionsResultToKotlin(getTopicSubscriptionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of MNS topics in an Alibaba Cloud account according to the specified parameters.
     * > **DEPRECATED:**  This datasource has been deprecated from version `1.188.0`. Please use new datasource message_service_topics.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const topics = alicloud.mns.getTopics({
     *     namePrefix: "tf-",
     * });
     * export const firstTopicId = topics.then(topics => topics.topics?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * topics = alicloud.mns.get_topics(name_prefix="tf-")
     * pulumi.export("firstTopicId", topics.topics[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var topics = AliCloud.Mns.GetTopics.Invoke(new()
     *     {
     *         NamePrefix = "tf-",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTopicId"] = topics&#46;Apply(getTopicsResult => getTopicsResult&#46;Topics[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		topics, err := mns.GetTopics(ctx, &mns.GetTopicsArgs{
     * 			NamePrefix: pulumi.StringRef("tf-"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTopicId", topics.Topics[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mns.MnsFunctions;
     * import com.pulumi.alicloud.mns.inputs.GetTopicsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var topics = MnsFunctions.getTopics(GetTopicsArgs.builder()
     *             .namePrefix("tf-")
     *             .build());
     *         ctx.export("firstTopicId", topics.applyValue(getTopicsResult -> getTopicsResult.topics()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   topics:
     *     fn::invoke:
     *       Function: alicloud:mns:getTopics
     *       Arguments:
     *         namePrefix: tf-
     * outputs:
     *   firstTopicId: ${topics.topics[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTopics.
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(argument: GetTopicsPlainArgs): GetTopicsResult =
        getTopicsResultToKotlin(getTopicsPlain(argument.toJava()).await())

    /**
     * @see [getTopics].
     * @param namePrefix A string to filter resulting topics by their name prefixs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(namePrefix: String? = null, outputFile: String? = null): GetTopicsResult {
        val argument = GetTopicsPlainArgs(
            namePrefix = namePrefix,
            outputFile = outputFile,
        )
        return getTopicsResultToKotlin(getTopicsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopics].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mns&#46;kotlin&#46;inputs&#46;GetTopicsPlainArgs].
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(argument: suspend GetTopicsPlainArgsBuilder.() -> Unit): GetTopicsResult {
        val builder = GetTopicsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicsResultToKotlin(getTopicsPlain(builtArgument.toJava()).await())
    }
}
