@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Queue].
 */
@PulumiTagMarker
public class QueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueueArgs = QueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueueArgsBuilder.() -> Unit) {
        val builder = QueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Queue {
        val builtJavaResource = com.pulumi.alicloud.mns.Queue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Queue(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const queue = new alicloud.mns.Queue("queue", {
 *     name: "tf-example-mnsqueue",
 *     delaySeconds: 0,
 *     maximumMessageSize: 65536,
 *     messageRetentionPeriod: 345600,
 *     visibilityTimeout: 30,
 *     pollingWaitSeconds: 0,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * queue = alicloud.mns.Queue("queue",
 *     name="tf-example-mnsqueue",
 *     delay_seconds=0,
 *     maximum_message_size=65536,
 *     message_retention_period=345600,
 *     visibility_timeout=30,
 *     polling_wait_seconds=0)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new AliCloud.Mns.Queue("queue", new()
 *     {
 *         Name = "tf-example-mnsqueue",
 *         DelaySeconds = 0,
 *         MaximumMessageSize = 65536,
 *         MessageRetentionPeriod = 345600,
 *         VisibilityTimeout = 30,
 *         PollingWaitSeconds = 0,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mns.NewQueue(ctx, "queue", &mns.QueueArgs{
 * 			Name:                   pulumi.String("tf-example-mnsqueue"),
 * 			DelaySeconds:           pulumi.Int(0),
 * 			MaximumMessageSize:     pulumi.Int(65536),
 * 			MessageRetentionPeriod: pulumi.Int(345600),
 * 			VisibilityTimeout:      pulumi.Int(30),
 * 			PollingWaitSeconds:     pulumi.Int(0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mns.Queue;
 * import com.pulumi.alicloud.mns.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .name("tf-example-mnsqueue")
 *             .delaySeconds(0)
 *             .maximumMessageSize(65536)
 *             .messageRetentionPeriod(345600)
 *             .visibilityTimeout(30)
 *             .pollingWaitSeconds(0)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   queue:
 *     type: alicloud:mns:Queue
 *     properties:
 *       name: tf-example-mnsqueue
 *       delaySeconds: 0
 *       maximumMessageSize: 65536
 *       messageRetentionPeriod: 345600
 *       visibilityTimeout: 30
 *       pollingWaitSeconds: 0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MNS QUEUE can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:mns/queue:Queue queue queuename
 * ```
 */
public class Queue internal constructor(
    override val javaResource: com.pulumi.alicloud.mns.Queue,
) : KotlinCustomResource(javaResource, QueueMapper) {
    /**
     * This attribute defines the length of time, in seconds, after which every message sent to the queue is dequeued. Valid value range: 0-604800 seconds, i.e., 0 to 7 days. Default value to 0.
     */
    public val delaySeconds: Output<Int>?
        get() = javaResource.delaySeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This indicates the maximum length, in bytes, of any message body sent to the queue. Valid value range: 1024-65536, i.e., 1K to 64K. Default value to 65536.
     */
    public val maximumMessageSize: Output<Int>?
        get() = javaResource.maximumMessageSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Messages are deleted from the queue after a specified length of time, whether they have been activated or not. This attribute defines the viability period, in seconds, for every message in the queue. Valid value range: 60-604800 seconds, i.e., 1 minutes to 7 days. Default value to 345600.
     */
    public val messageRetentionPeriod: Output<Int>?
        get() = javaResource.messageRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Two queues on a single account in the same region cannot have the same name. A queue name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters .
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Long polling is measured in seconds. When this attribute is set to 0, long polling is disabled. When it is not set to 0, long polling is enabled and message dequeue requests will be processed only when valid messages are received or when long polling times out. Valid value range: 0-30 seconds. Default value to 0.
     */
    public val pollingWaitSeconds: Output<Int>?
        get() = javaResource.pollingWaitSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The VisibilityTimeout attribute of the queue. A dequeued messages will change from active (visible) status to inactive (invisible) status, and this attribute defines the length of time, in seconds, that messages remain invisible. Messages return to active status after the set period. Valid value range: 1-43200 seconds, i.e., 1 seconds to 12 hours. Default value to 30.
     */
    public val visibilityTimeout: Output<Int>?
        get() = javaResource.visibilityTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object QueueMapper : ResourceMapper<Queue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mns.Queue::class == javaResource::class

    override fun map(javaResource: Resource): Queue = Queue(
        javaResource as
            com.pulumi.alicloud.mns.Queue,
    )
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Queue].
 */
public suspend fun queue(name: String, block: suspend QueueResourceBuilder.() -> Unit): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queue(name: String): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
