@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin

import com.pulumi.alicloud.mns.QueueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const queue = new alicloud.mns.Queue("queue", {
 *     name: "tf-example-mnsqueue",
 *     delaySeconds: 0,
 *     maximumMessageSize: 65536,
 *     messageRetentionPeriod: 345600,
 *     visibilityTimeout: 30,
 *     pollingWaitSeconds: 0,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * queue = alicloud.mns.Queue("queue",
 *     name="tf-example-mnsqueue",
 *     delay_seconds=0,
 *     maximum_message_size=65536,
 *     message_retention_period=345600,
 *     visibility_timeout=30,
 *     polling_wait_seconds=0)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new AliCloud.Mns.Queue("queue", new()
 *     {
 *         Name = "tf-example-mnsqueue",
 *         DelaySeconds = 0,
 *         MaximumMessageSize = 65536,
 *         MessageRetentionPeriod = 345600,
 *         VisibilityTimeout = 30,
 *         PollingWaitSeconds = 0,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mns.NewQueue(ctx, "queue", &mns.QueueArgs{
 * 			Name:                   pulumi.String("tf-example-mnsqueue"),
 * 			DelaySeconds:           pulumi.Int(0),
 * 			MaximumMessageSize:     pulumi.Int(65536),
 * 			MessageRetentionPeriod: pulumi.Int(345600),
 * 			VisibilityTimeout:      pulumi.Int(30),
 * 			PollingWaitSeconds:     pulumi.Int(0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mns.Queue;
 * import com.pulumi.alicloud.mns.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .name("tf-example-mnsqueue")
 *             .delaySeconds(0)
 *             .maximumMessageSize(65536)
 *             .messageRetentionPeriod(345600)
 *             .visibilityTimeout(30)
 *             .pollingWaitSeconds(0)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   queue:
 *     type: alicloud:mns:Queue
 *     properties:
 *       name: tf-example-mnsqueue
 *       delaySeconds: 0
 *       maximumMessageSize: 65536
 *       messageRetentionPeriod: 345600
 *       visibilityTimeout: 30
 *       pollingWaitSeconds: 0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MNS QUEUE can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:mns/queue:Queue queue queuename
 * ```
 * @property delaySeconds This attribute defines the length of time, in seconds, after which every message sent to the queue is dequeued. Valid value range: 0-604800 seconds, i.e., 0 to 7 days. Default value to 0.
 * @property maximumMessageSize This indicates the maximum length, in bytes, of any message body sent to the queue. Valid value range: 1024-65536, i.e., 1K to 64K. Default value to 65536.
 * @property messageRetentionPeriod Messages are deleted from the queue after a specified length of time, whether they have been activated or not. This attribute defines the viability period, in seconds, for every message in the queue. Valid value range: 60-604800 seconds, i.e., 1 minutes to 7 days. Default value to 345600.
 * @property name Two queues on a single account in the same region cannot have the same name. A queue name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters .
 * @property pollingWaitSeconds Long polling is measured in seconds. When this attribute is set to 0, long polling is disabled. When it is not set to 0, long polling is enabled and message dequeue requests will be processed only when valid messages are received or when long polling times out. Valid value range: 0-30 seconds. Default value to 0.
 * @property visibilityTimeout The VisibilityTimeout attribute of the queue. A dequeued messages will change from active (visible) status to inactive (invisible) status, and this attribute defines the length of time, in seconds, that messages remain invisible. Messages return to active status after the set period. Valid value range: 1-43200 seconds, i.e., 1 seconds to 12 hours. Default value to 30.
 */
public data class QueueArgs(
    public val delaySeconds: Output<Int>? = null,
    public val maximumMessageSize: Output<Int>? = null,
    public val messageRetentionPeriod: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val pollingWaitSeconds: Output<Int>? = null,
    public val visibilityTimeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mns.QueueArgs> {
    override fun toJava(): com.pulumi.alicloud.mns.QueueArgs =
        com.pulumi.alicloud.mns.QueueArgs.builder()
            .delaySeconds(delaySeconds?.applyValue({ args0 -> args0 }))
            .maximumMessageSize(maximumMessageSize?.applyValue({ args0 -> args0 }))
            .messageRetentionPeriod(messageRetentionPeriod?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .pollingWaitSeconds(pollingWaitSeconds?.applyValue({ args0 -> args0 }))
            .visibilityTimeout(visibilityTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueueArgs].
 */
@PulumiTagMarker
public class QueueArgsBuilder internal constructor() {
    private var delaySeconds: Output<Int>? = null

    private var maximumMessageSize: Output<Int>? = null

    private var messageRetentionPeriod: Output<Int>? = null

    private var name: Output<String>? = null

    private var pollingWaitSeconds: Output<Int>? = null

    private var visibilityTimeout: Output<Int>? = null

    /**
     * @param value This attribute defines the length of time, in seconds, after which every message sent to the queue is dequeued. Valid value range: 0-604800 seconds, i.e., 0 to 7 days. Default value to 0.
     */
    @JvmName("crrhymxmeflpptct")
    public suspend fun delaySeconds(`value`: Output<Int>) {
        this.delaySeconds = value
    }

    /**
     * @param value This indicates the maximum length, in bytes, of any message body sent to the queue. Valid value range: 1024-65536, i.e., 1K to 64K. Default value to 65536.
     */
    @JvmName("bjfcrdelrixotqbg")
    public suspend fun maximumMessageSize(`value`: Output<Int>) {
        this.maximumMessageSize = value
    }

    /**
     * @param value Messages are deleted from the queue after a specified length of time, whether they have been activated or not. This attribute defines the viability period, in seconds, for every message in the queue. Valid value range: 60-604800 seconds, i.e., 1 minutes to 7 days. Default value to 345600.
     */
    @JvmName("wayaatplkugyrsfp")
    public suspend fun messageRetentionPeriod(`value`: Output<Int>) {
        this.messageRetentionPeriod = value
    }

    /**
     * @param value Two queues on a single account in the same region cannot have the same name. A queue name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters .
     */
    @JvmName("ckuuevglmecfwhow")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Long polling is measured in seconds. When this attribute is set to 0, long polling is disabled. When it is not set to 0, long polling is enabled and message dequeue requests will be processed only when valid messages are received or when long polling times out. Valid value range: 0-30 seconds. Default value to 0.
     */
    @JvmName("jtpuegyrggmbdupt")
    public suspend fun pollingWaitSeconds(`value`: Output<Int>) {
        this.pollingWaitSeconds = value
    }

    /**
     * @param value The VisibilityTimeout attribute of the queue. A dequeued messages will change from active (visible) status to inactive (invisible) status, and this attribute defines the length of time, in seconds, that messages remain invisible. Messages return to active status after the set period. Valid value range: 1-43200 seconds, i.e., 1 seconds to 12 hours. Default value to 30.
     */
    @JvmName("umvjngcmuwyfxmko")
    public suspend fun visibilityTimeout(`value`: Output<Int>) {
        this.visibilityTimeout = value
    }

    /**
     * @param value This attribute defines the length of time, in seconds, after which every message sent to the queue is dequeued. Valid value range: 0-604800 seconds, i.e., 0 to 7 days. Default value to 0.
     */
    @JvmName("cbbrxthwtpdtdgpa")
    public suspend fun delaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delaySeconds = mapped
    }

    /**
     * @param value This indicates the maximum length, in bytes, of any message body sent to the queue. Valid value range: 1024-65536, i.e., 1K to 64K. Default value to 65536.
     */
    @JvmName("egrnhdfeeinppdsb")
    public suspend fun maximumMessageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumMessageSize = mapped
    }

    /**
     * @param value Messages are deleted from the queue after a specified length of time, whether they have been activated or not. This attribute defines the viability period, in seconds, for every message in the queue. Valid value range: 60-604800 seconds, i.e., 1 minutes to 7 days. Default value to 345600.
     */
    @JvmName("bhuxprhoktoowyqa")
    public suspend fun messageRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageRetentionPeriod = mapped
    }

    /**
     * @param value Two queues on a single account in the same region cannot have the same name. A queue name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters .
     */
    @JvmName("wvkdvyloxkarskdp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Long polling is measured in seconds. When this attribute is set to 0, long polling is disabled. When it is not set to 0, long polling is enabled and message dequeue requests will be processed only when valid messages are received or when long polling times out. Valid value range: 0-30 seconds. Default value to 0.
     */
    @JvmName("lomxiqvohlxvajvg")
    public suspend fun pollingWaitSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pollingWaitSeconds = mapped
    }

    /**
     * @param value The VisibilityTimeout attribute of the queue. A dequeued messages will change from active (visible) status to inactive (invisible) status, and this attribute defines the length of time, in seconds, that messages remain invisible. Messages return to active status after the set period. Valid value range: 1-43200 seconds, i.e., 1 seconds to 12 hours. Default value to 30.
     */
    @JvmName("icpkcbisgkjaltld")
    public suspend fun visibilityTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibilityTimeout = mapped
    }

    internal fun build(): QueueArgs = QueueArgs(
        delaySeconds = delaySeconds,
        maximumMessageSize = maximumMessageSize,
        messageRetentionPeriod = messageRetentionPeriod,
        name = name,
        pollingWaitSeconds = pollingWaitSeconds,
        visibilityTimeout = visibilityTimeout,
    )
}
