@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Topic].
 */
@PulumiTagMarker
public class TopicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicArgs = TopicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicArgsBuilder.() -> Unit) {
        val builder = TopicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Topic {
        val builtJavaResource = com.pulumi.alicloud.mns.Topic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Topic(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const topic = new alicloud.mns.Topic("topic", {
 *     name: "tf-example-mnstopic",
 *     maximumMessageSize: 65536,
 *     loggingEnabled: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * topic = alicloud.mns.Topic("topic",
 *     name="tf-example-mnstopic",
 *     maximum_message_size=65536,
 *     logging_enabled=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = new AliCloud.Mns.Topic("topic", new()
 *     {
 *         Name = "tf-example-mnstopic",
 *         MaximumMessageSize = 65536,
 *         LoggingEnabled = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mns.NewTopic(ctx, "topic", &mns.TopicArgs{
 * 			Name:               pulumi.String("tf-example-mnstopic"),
 * 			MaximumMessageSize: pulumi.Int(65536),
 * 			LoggingEnabled:     pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mns.Topic;
 * import com.pulumi.alicloud.mns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topic = new Topic("topic", TopicArgs.builder()
 *             .name("tf-example-mnstopic")
 *             .maximumMessageSize(65536)
 *             .loggingEnabled(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   topic:
 *     type: alicloud:mns:Topic
 *     properties:
 *       name: tf-example-mnstopic
 *       maximumMessageSize: 65536
 *       loggingEnabled: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MNS Topic can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:mns/topic:Topic topic topicName
 * ```
 */
public class Topic internal constructor(
    override val javaResource: com.pulumi.alicloud.mns.Topic,
) : KotlinCustomResource(javaResource, TopicMapper) {
    /**
     * Is logging enabled? true or false. Default value to false.
     */
    public val loggingEnabled: Output<Boolean>?
        get() = javaResource.loggingEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This indicates the maximum length, in bytes, of any message body sent to the topic. Valid value range: 1024-65536, i.e., 1K to 64K. Default value to 65536.
     */
    public val maximumMessageSize: Output<Int>?
        get() = javaResource.maximumMessageSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object TopicMapper : ResourceMapper<Topic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mns.Topic::class == javaResource::class

    override fun map(javaResource: Resource): Topic = Topic(
        javaResource as
            com.pulumi.alicloud.mns.Topic,
    )
}

/**
 * @see [Topic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Topic].
 */
public suspend fun topic(name: String, block: suspend TopicResourceBuilder.() -> Unit): Topic {
    val builder = TopicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Topic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topic(name: String): Topic {
    val builder = TopicResourceBuilder()
    builder.name(name)
    return builder.build()
}
