@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin

import com.pulumi.alicloud.mns.TopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const topic = new alicloud.mns.Topic("topic", {
 *     name: "tf-example-mnstopic",
 *     maximumMessageSize: 65536,
 *     loggingEnabled: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * topic = alicloud.mns.Topic("topic",
 *     name="tf-example-mnstopic",
 *     maximum_message_size=65536,
 *     logging_enabled=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = new AliCloud.Mns.Topic("topic", new()
 *     {
 *         Name = "tf-example-mnstopic",
 *         MaximumMessageSize = 65536,
 *         LoggingEnabled = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mns.NewTopic(ctx, "topic", &mns.TopicArgs{
 * 			Name:               pulumi.String("tf-example-mnstopic"),
 * 			MaximumMessageSize: pulumi.Int(65536),
 * 			LoggingEnabled:     pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mns.Topic;
 * import com.pulumi.alicloud.mns.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topic = new Topic("topic", TopicArgs.builder()
 *             .name("tf-example-mnstopic")
 *             .maximumMessageSize(65536)
 *             .loggingEnabled(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   topic:
 *     type: alicloud:mns:Topic
 *     properties:
 *       name: tf-example-mnstopic
 *       maximumMessageSize: 65536
 *       loggingEnabled: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MNS Topic can be imported using the id or name, e.g.
 * ```sh
 * $ pulumi import alicloud:mns/topic:Topic topic topicName
 * ```
 * @property loggingEnabled Is logging enabled? true or false. Default value to false.
 * @property maximumMessageSize This indicates the maximum length, in bytes, of any message body sent to the topic. Valid value range: 1024-65536, i.e., 1K to 64K. Default value to 65536.
 * @property name Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
 */
public data class TopicArgs(
    public val loggingEnabled: Output<Boolean>? = null,
    public val maximumMessageSize: Output<Int>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mns.TopicArgs> {
    override fun toJava(): com.pulumi.alicloud.mns.TopicArgs =
        com.pulumi.alicloud.mns.TopicArgs.builder()
            .loggingEnabled(loggingEnabled?.applyValue({ args0 -> args0 }))
            .maximumMessageSize(maximumMessageSize?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicArgs].
 */
@PulumiTagMarker
public class TopicArgsBuilder internal constructor() {
    private var loggingEnabled: Output<Boolean>? = null

    private var maximumMessageSize: Output<Int>? = null

    private var name: Output<String>? = null

    /**
     * @param value Is logging enabled? true or false. Default value to false.
     */
    @JvmName("fwspkstxmbccwspm")
    public suspend fun loggingEnabled(`value`: Output<Boolean>) {
        this.loggingEnabled = value
    }

    /**
     * @param value This indicates the maximum length, in bytes, of any message body sent to the topic. Valid value range: 1024-65536, i.e., 1K to 64K. Default value to 65536.
     */
    @JvmName("jvgaodpkbnosqvva")
    public suspend fun maximumMessageSize(`value`: Output<Int>) {
        this.maximumMessageSize = value
    }

    /**
     * @param value Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    @JvmName("ggngnkfcwsvwfwqb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Is logging enabled? true or false. Default value to false.
     */
    @JvmName("vvnwawviisxdfmwr")
    public suspend fun loggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingEnabled = mapped
    }

    /**
     * @param value This indicates the maximum length, in bytes, of any message body sent to the topic. Valid value range: 1024-65536, i.e., 1K to 64K. Default value to 65536.
     */
    @JvmName("oiguvvftggtpiumf")
    public suspend fun maximumMessageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumMessageSize = mapped
    }

    /**
     * @param value Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    @JvmName("hboqqsqoijaluktx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TopicArgs = TopicArgs(
        loggingEnabled = loggingEnabled,
        maximumMessageSize = maximumMessageSize,
        name = name,
    )
}
