@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TopicSubscription].
 */
@PulumiTagMarker
public class TopicSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicSubscriptionArgs = TopicSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicSubscriptionArgsBuilder.() -> Unit) {
        val builder = TopicSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TopicSubscription {
        val builtJavaResource = com.pulumi.alicloud.mns.TopicSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TopicSubscription(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const topic = new alicloud.mns.Topic("topic", {
 *     name: "tf-example-mnstopic",
 *     maximumMessageSize: 65536,
 *     loggingEnabled: false,
 * });
 * const subscription = new alicloud.mns.TopicSubscription("subscription", {
 *     topicName: "tf-example-mnstopic",
 *     name: "tf-example-mnstopic-sub",
 *     filterTag: "test",
 *     endpoint: "http://www.xxx.com/xxx",
 *     notifyStrategy: "BACKOFF_RETRY",
 *     notifyContentFormat: "XML",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * topic = alicloud.mns.Topic("topic",
 *     name="tf-example-mnstopic",
 *     maximum_message_size=65536,
 *     logging_enabled=False)
 * subscription = alicloud.mns.TopicSubscription("subscription",
 *     topic_name="tf-example-mnstopic",
 *     name="tf-example-mnstopic-sub",
 *     filter_tag="test",
 *     endpoint="http://www.xxx.com/xxx",
 *     notify_strategy="BACKOFF_RETRY",
 *     notify_content_format="XML")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = new AliCloud.Mns.Topic("topic", new()
 *     {
 *         Name = "tf-example-mnstopic",
 *         MaximumMessageSize = 65536,
 *         LoggingEnabled = false,
 *     });
 *     var subscription = new AliCloud.Mns.TopicSubscription("subscription", new()
 *     {
 *         TopicName = "tf-example-mnstopic",
 *         Name = "tf-example-mnstopic-sub",
 *         FilterTag = "test",
 *         Endpoint = "http://www.xxx.com/xxx",
 *         NotifyStrategy = "BACKOFF_RETRY",
 *         NotifyContentFormat = "XML",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mns.NewTopic(ctx, "topic", &mns.TopicArgs{
 * 			Name:               pulumi.String("tf-example-mnstopic"),
 * 			MaximumMessageSize: pulumi.Int(65536),
 * 			LoggingEnabled:     pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mns.NewTopicSubscription(ctx, "subscription", &mns.TopicSubscriptionArgs{
 * 			TopicName:           pulumi.String("tf-example-mnstopic"),
 * 			Name:                pulumi.String("tf-example-mnstopic-sub"),
 * 			FilterTag:           pulumi.String("test"),
 * 			Endpoint:            pulumi.String("http://www.xxx.com/xxx"),
 * 			NotifyStrategy:      pulumi.String("BACKOFF_RETRY"),
 * 			NotifyContentFormat: pulumi.String("XML"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mns.Topic;
 * import com.pulumi.alicloud.mns.TopicArgs;
 * import com.pulumi.alicloud.mns.TopicSubscription;
 * import com.pulumi.alicloud.mns.TopicSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topic = new Topic("topic", TopicArgs.builder()
 *             .name("tf-example-mnstopic")
 *             .maximumMessageSize(65536)
 *             .loggingEnabled(false)
 *             .build());
 *         var subscription = new TopicSubscription("subscription", TopicSubscriptionArgs.builder()
 *             .topicName("tf-example-mnstopic")
 *             .name("tf-example-mnstopic-sub")
 *             .filterTag("test")
 *             .endpoint("http://www.xxx.com/xxx")
 *             .notifyStrategy("BACKOFF_RETRY")
 *             .notifyContentFormat("XML")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   topic:
 *     type: alicloud:mns:Topic
 *     properties:
 *       name: tf-example-mnstopic
 *       maximumMessageSize: 65536
 *       loggingEnabled: false
 *   subscription:
 *     type: alicloud:mns:TopicSubscription
 *     properties:
 *       topicName: tf-example-mnstopic
 *       name: tf-example-mnstopic-sub
 *       filterTag: test
 *       endpoint: http://www.xxx.com/xxx
 *       notifyStrategy: BACKOFF_RETRY
 *       notifyContentFormat: XML
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MNS Topic subscription can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mns/topicSubscription:TopicSubscription subscription tf-example-mnstopic:tf-example-mnstopic-sub
 * ```
 */
public class TopicSubscription internal constructor(
    override val javaResource: com.pulumi.alicloud.mns.TopicSubscription,
) : KotlinCustomResource(javaResource, TopicSubscriptionMapper) {
    /**
     * The endpoint has three format. Available values format:
     * - `HTTP Format`: http://xxx.com/xxx
     * - `Queue Format`: acs:mns:{REGION}:{AccountID}:queues/{QueueName}
     * - `Email Format`: mail:directmail:{MailAddress}
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The length should be shorter than 16.
     */
    public val filterTag: Output<String>?
        get() = javaResource.filterTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Two topics subscription on a single account in the same topic cannot have the same name. A topic subscription name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The NotifyContentFormat attribute of Subscription. This attribute specifies the content format of the messages pushed to users. The valid values: `SIMPLIFIED`, `XML` and `JSON`. Default to `SIMPLIFIED`.
     */
    public val notifyContentFormat: Output<String>?
        get() = javaResource.notifyContentFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The NotifyStrategy attribute of Subscription. This attribute specifies the retry strategy when message sending fails. The Valid values: `EXPONENTIAL_DECAY_RETRY` and `BACKOFF_RETRY`. Default value to `BACKOFF_RETRY` .
     */
    public val notifyStrategy: Output<String>?
        get() = javaResource.notifyStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The topic which The subscription belongs to was named with the name.A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    public val topicName: Output<String>
        get() = javaResource.topicName().applyValue({ args0 -> args0 })
}

public object TopicSubscriptionMapper : ResourceMapper<TopicSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mns.TopicSubscription::class == javaResource::class

    override fun map(javaResource: Resource): TopicSubscription = TopicSubscription(
        javaResource as
            com.pulumi.alicloud.mns.TopicSubscription,
    )
}

/**
 * @see [TopicSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TopicSubscription].
 */
public suspend fun topicSubscription(
    name: String,
    block: suspend TopicSubscriptionResourceBuilder.() -> Unit,
): TopicSubscription {
    val builder = TopicSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TopicSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topicSubscription(name: String): TopicSubscription {
    val builder = TopicSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
