@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin

import com.pulumi.alicloud.mns.TopicSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const topic = new alicloud.mns.Topic("topic", {
 *     name: "tf-example-mnstopic",
 *     maximumMessageSize: 65536,
 *     loggingEnabled: false,
 * });
 * const subscription = new alicloud.mns.TopicSubscription("subscription", {
 *     topicName: "tf-example-mnstopic",
 *     name: "tf-example-mnstopic-sub",
 *     filterTag: "test",
 *     endpoint: "http://www.xxx.com/xxx",
 *     notifyStrategy: "BACKOFF_RETRY",
 *     notifyContentFormat: "XML",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * topic = alicloud.mns.Topic("topic",
 *     name="tf-example-mnstopic",
 *     maximum_message_size=65536,
 *     logging_enabled=False)
 * subscription = alicloud.mns.TopicSubscription("subscription",
 *     topic_name="tf-example-mnstopic",
 *     name="tf-example-mnstopic-sub",
 *     filter_tag="test",
 *     endpoint="http://www.xxx.com/xxx",
 *     notify_strategy="BACKOFF_RETRY",
 *     notify_content_format="XML")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = new AliCloud.Mns.Topic("topic", new()
 *     {
 *         Name = "tf-example-mnstopic",
 *         MaximumMessageSize = 65536,
 *         LoggingEnabled = false,
 *     });
 *     var subscription = new AliCloud.Mns.TopicSubscription("subscription", new()
 *     {
 *         TopicName = "tf-example-mnstopic",
 *         Name = "tf-example-mnstopic-sub",
 *         FilterTag = "test",
 *         Endpoint = "http://www.xxx.com/xxx",
 *         NotifyStrategy = "BACKOFF_RETRY",
 *         NotifyContentFormat = "XML",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mns.NewTopic(ctx, "topic", &mns.TopicArgs{
 * 			Name:               pulumi.String("tf-example-mnstopic"),
 * 			MaximumMessageSize: pulumi.Int(65536),
 * 			LoggingEnabled:     pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mns.NewTopicSubscription(ctx, "subscription", &mns.TopicSubscriptionArgs{
 * 			TopicName:           pulumi.String("tf-example-mnstopic"),
 * 			Name:                pulumi.String("tf-example-mnstopic-sub"),
 * 			FilterTag:           pulumi.String("test"),
 * 			Endpoint:            pulumi.String("http://www.xxx.com/xxx"),
 * 			NotifyStrategy:      pulumi.String("BACKOFF_RETRY"),
 * 			NotifyContentFormat: pulumi.String("XML"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mns.Topic;
 * import com.pulumi.alicloud.mns.TopicArgs;
 * import com.pulumi.alicloud.mns.TopicSubscription;
 * import com.pulumi.alicloud.mns.TopicSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topic = new Topic("topic", TopicArgs.builder()
 *             .name("tf-example-mnstopic")
 *             .maximumMessageSize(65536)
 *             .loggingEnabled(false)
 *             .build());
 *         var subscription = new TopicSubscription("subscription", TopicSubscriptionArgs.builder()
 *             .topicName("tf-example-mnstopic")
 *             .name("tf-example-mnstopic-sub")
 *             .filterTag("test")
 *             .endpoint("http://www.xxx.com/xxx")
 *             .notifyStrategy("BACKOFF_RETRY")
 *             .notifyContentFormat("XML")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   topic:
 *     type: alicloud:mns:Topic
 *     properties:
 *       name: tf-example-mnstopic
 *       maximumMessageSize: 65536
 *       loggingEnabled: false
 *   subscription:
 *     type: alicloud:mns:TopicSubscription
 *     properties:
 *       topicName: tf-example-mnstopic
 *       name: tf-example-mnstopic-sub
 *       filterTag: test
 *       endpoint: http://www.xxx.com/xxx
 *       notifyStrategy: BACKOFF_RETRY
 *       notifyContentFormat: XML
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MNS Topic subscription can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mns/topicSubscription:TopicSubscription subscription tf-example-mnstopic:tf-example-mnstopic-sub
 * ```
 * @property endpoint The endpoint has three format. Available values format:
 * - `HTTP Format`: http://xxx.com/xxx
 * - `Queue Format`: acs:mns:{REGION}:{AccountID}:queues/{QueueName}
 * - `Email Format`: mail:directmail:{MailAddress}
 * @property filterTag The length should be shorter than 16.
 * @property name Two topics subscription on a single account in the same topic cannot have the same name. A topic subscription name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
 * @property notifyContentFormat The NotifyContentFormat attribute of Subscription. This attribute specifies the content format of the messages pushed to users. The valid values: `SIMPLIFIED`, `XML` and `JSON`. Default to `SIMPLIFIED`.
 * @property notifyStrategy The NotifyStrategy attribute of Subscription. This attribute specifies the retry strategy when message sending fails. The Valid values: `EXPONENTIAL_DECAY_RETRY` and `BACKOFF_RETRY`. Default value to `BACKOFF_RETRY` .
 * @property topicName The topic which The subscription belongs to was named with the name.A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
 */
public data class TopicSubscriptionArgs(
    public val endpoint: Output<String>? = null,
    public val filterTag: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notifyContentFormat: Output<String>? = null,
    public val notifyStrategy: Output<String>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mns.TopicSubscriptionArgs> {
    override fun toJava(): com.pulumi.alicloud.mns.TopicSubscriptionArgs =
        com.pulumi.alicloud.mns.TopicSubscriptionArgs.builder()
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .filterTag(filterTag?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notifyContentFormat(notifyContentFormat?.applyValue({ args0 -> args0 }))
            .notifyStrategy(notifyStrategy?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicSubscriptionArgs].
 */
@PulumiTagMarker
public class TopicSubscriptionArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var filterTag: Output<String>? = null

    private var name: Output<String>? = null

    private var notifyContentFormat: Output<String>? = null

    private var notifyStrategy: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value The endpoint has three format. Available values format:
     * - `HTTP Format`: http://xxx.com/xxx
     * - `Queue Format`: acs:mns:{REGION}:{AccountID}:queues/{QueueName}
     * - `Email Format`: mail:directmail:{MailAddress}
     */
    @JvmName("fuxpbnnyyokpjxbr")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The length should be shorter than 16.
     */
    @JvmName("codtfmexsynbrvxk")
    public suspend fun filterTag(`value`: Output<String>) {
        this.filterTag = value
    }

    /**
     * @param value Two topics subscription on a single account in the same topic cannot have the same name. A topic subscription name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    @JvmName("rxujtkyyfghxkkwj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The NotifyContentFormat attribute of Subscription. This attribute specifies the content format of the messages pushed to users. The valid values: `SIMPLIFIED`, `XML` and `JSON`. Default to `SIMPLIFIED`.
     */
    @JvmName("ynyalioaxstegplt")
    public suspend fun notifyContentFormat(`value`: Output<String>) {
        this.notifyContentFormat = value
    }

    /**
     * @param value The NotifyStrategy attribute of Subscription. This attribute specifies the retry strategy when message sending fails. The Valid values: `EXPONENTIAL_DECAY_RETRY` and `BACKOFF_RETRY`. Default value to `BACKOFF_RETRY` .
     */
    @JvmName("jrvbirbxoionodtn")
    public suspend fun notifyStrategy(`value`: Output<String>) {
        this.notifyStrategy = value
    }

    /**
     * @param value The topic which The subscription belongs to was named with the name.A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    @JvmName("vponekbuytplgqyi")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value The endpoint has three format. Available values format:
     * - `HTTP Format`: http://xxx.com/xxx
     * - `Queue Format`: acs:mns:{REGION}:{AccountID}:queues/{QueueName}
     * - `Email Format`: mail:directmail:{MailAddress}
     */
    @JvmName("iivxwbsjnclncuqm")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The length should be shorter than 16.
     */
    @JvmName("monwrjoaccmnguss")
    public suspend fun filterTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterTag = mapped
    }

    /**
     * @param value Two topics subscription on a single account in the same topic cannot have the same name. A topic subscription name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    @JvmName("vvjkweulcafuixgc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The NotifyContentFormat attribute of Subscription. This attribute specifies the content format of the messages pushed to users. The valid values: `SIMPLIFIED`, `XML` and `JSON`. Default to `SIMPLIFIED`.
     */
    @JvmName("hrvjanymltlivdjn")
    public suspend fun notifyContentFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyContentFormat = mapped
    }

    /**
     * @param value The NotifyStrategy attribute of Subscription. This attribute specifies the retry strategy when message sending fails. The Valid values: `EXPONENTIAL_DECAY_RETRY` and `BACKOFF_RETRY`. Default value to `BACKOFF_RETRY` .
     */
    @JvmName("tbaydacgxvwrkkjq")
    public suspend fun notifyStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyStrategy = mapped
    }

    /**
     * @param value The topic which The subscription belongs to was named with the name.A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    @JvmName("cuordtuoebpbdros")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): TopicSubscriptionArgs = TopicSubscriptionArgs(
        endpoint = endpoint,
        filterTag = filterTag,
        name = name,
        notifyContentFormat = notifyContentFormat,
        notifyStrategy = notifyStrategy,
        topicName = topicName,
    )
}
