@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.inputs

import com.pulumi.alicloud.mns.inputs.GetQueuesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQueues.
 * @property namePrefix A string to filter resulting queues by their name prefixs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetQueuesPlainArgs(
    public val namePrefix: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mns.inputs.GetQueuesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mns.inputs.GetQueuesPlainArgs =
        com.pulumi.alicloud.mns.inputs.GetQueuesPlainArgs.builder()
            .namePrefix(namePrefix?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQueuesPlainArgs].
 */
@PulumiTagMarker
public class GetQueuesPlainArgsBuilder internal constructor() {
    private var namePrefix: String? = null

    private var outputFile: String? = null

    /**
     * @param value A string to filter resulting queues by their name prefixs.
     */
    @JvmName("votdtyokrpktvbdo")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qjnitwpyobvvapdl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetQueuesPlainArgs = GetQueuesPlainArgs(
        namePrefix = namePrefix,
        outputFile = outputFile,
    )
}
