@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.inputs

import com.pulumi.alicloud.mns.inputs.GetTopicSubscriptionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTopicSubscriptions.
 * @property namePrefix A string to filter resulting subscriptions of the topic by their name prefixs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property topicName Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
 */
public data class GetTopicSubscriptionsPlainArgs(
    public val namePrefix: String? = null,
    public val outputFile: String? = null,
    public val topicName: String,
) : ConvertibleToJava<com.pulumi.alicloud.mns.inputs.GetTopicSubscriptionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mns.inputs.GetTopicSubscriptionsPlainArgs =
        com.pulumi.alicloud.mns.inputs.GetTopicSubscriptionsPlainArgs.builder()
            .namePrefix(namePrefix?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTopicSubscriptionsPlainArgs].
 */
@PulumiTagMarker
public class GetTopicSubscriptionsPlainArgsBuilder internal constructor() {
    private var namePrefix: String? = null

    private var outputFile: String? = null

    private var topicName: String? = null

    /**
     * @param value A string to filter resulting subscriptions of the topic by their name prefixs.
     */
    @JvmName("mmynfmjrnbpandev")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rqpqyfwprtxqtnmd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
     */
    @JvmName("lnsjithwxokompvr")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetTopicSubscriptionsPlainArgs = GetTopicSubscriptionsPlainArgs(
        namePrefix = namePrefix,
        outputFile = outputFile,
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
