@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.inputs

import com.pulumi.alicloud.mns.inputs.GetTopicsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTopics.
 * @property namePrefix A string to filter resulting topics by their name prefixs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetTopicsPlainArgs(
    public val namePrefix: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mns.inputs.GetTopicsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.mns.inputs.GetTopicsPlainArgs =
        com.pulumi.alicloud.mns.inputs.GetTopicsPlainArgs.builder()
            .namePrefix(namePrefix?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTopicsPlainArgs].
 */
@PulumiTagMarker
public class GetTopicsPlainArgsBuilder internal constructor() {
    private var namePrefix: String? = null

    private var outputFile: String? = null

    /**
     * @param value A string to filter resulting topics by their name prefixs.
     */
    @JvmName("tmkcpkdrlgptwwrx")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ahrfysxslcyriaby")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetTopicsPlainArgs = GetTopicsPlainArgs(
        namePrefix = namePrefix,
        outputFile = outputFile,
    )
}
