@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property delaySeconds This attribute defines the length of time, in seconds, after which every message sent to the queue is dequeued.
 * @property id The id of the queue, The value is set to `name`.
 * @property maximumMessageSize This indicates the maximum length, in bytes, of any message body sent to the queue.
 * @property messageRetentionPeriod Messages are deleted from the queue after a specified length of time, whether they have been activated or not. This attribute defines the viability period, in seconds, for every message in the queue.
 * @property name The name of the queue
 * @property pollingWaitSeconds Long polling is measured in seconds. When this attribute is set to 0, long polling is disabled. When it is not set to 0, long polling is enabled and message dequeue requests will be processed only when valid messages are received or when long polling times out.
 * @property visibilityTimeouts Dequeued messages change from active (visible) status to inactive (invisible) status. This attribute defines the length of time, in seconds, that messages remain invisible. Messages return to active status after the set period.
 */
public data class GetQueuesQueue(
    public val delaySeconds: Int,
    public val id: String,
    public val maximumMessageSize: Int,
    public val messageRetentionPeriod: Int,
    public val name: String,
    public val pollingWaitSeconds: Int,
    public val visibilityTimeouts: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mns.outputs.GetQueuesQueue): GetQueuesQueue =
            GetQueuesQueue(
                delaySeconds = javaType.delaySeconds(),
                id = javaType.id(),
                maximumMessageSize = javaType.maximumMessageSize(),
                messageRetentionPeriod = javaType.messageRetentionPeriod(),
                name = javaType.name(),
                pollingWaitSeconds = javaType.pollingWaitSeconds(),
                visibilityTimeouts = javaType.visibilityTimeouts(),
            )
    }
}
