@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getQueues.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property namePrefix
 * @property names A list of queue names.
 * @property outputFile
 * @property queues A list of queues. Each element contains the following attributes:
 */
public data class GetQueuesResult(
    public val id: String,
    public val namePrefix: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val queues: List<GetQueuesQueue>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mns.outputs.GetQueuesResult): GetQueuesResult = GetQueuesResult(
            id = javaType.id(),
            namePrefix = javaType.namePrefix().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            queues = javaType.queues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mns.kotlin.outputs.GetQueuesQueue.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
