@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTopicSubscriptions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property namePrefix
 * @property names A list of subscription names.
 * @property outputFile
 * @property subscriptions A list of subscriptions. Each element contains the following attributes:
 * @property topicName The topic which The subscription belongs to was named with the name.
 */
public data class GetTopicSubscriptionsResult(
    public val id: String,
    public val namePrefix: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val subscriptions: List<GetTopicSubscriptionsSubscription>,
    public val topicName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mns.outputs.GetTopicSubscriptionsResult): GetTopicSubscriptionsResult = GetTopicSubscriptionsResult(
            id = javaType.id(),
            namePrefix = javaType.namePrefix().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            subscriptions = javaType.subscriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mns.kotlin.outputs.GetTopicSubscriptionsSubscription.Companion.toKotlin(args0)
                })
            }),
            topicName = javaType.topicName(),
        )
    }
}
