@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpoint Describe the terminal address of the message received in this subscription.
 * @property filterTag A string to filter resulting messages of the topic by their message tag.
 * @property id The ID of the topic subscription. The value is set to `name`.
 * @property name The name of the subscription.
 * @property notifyContentFormat The NotifyContentFormat attribute of Subscription. This attribute specifies the content format of the messages pushed to users.
 * @property notifyStrategy The NotifyStrategy attribute of Subscription. This attribute specifies the retry strategy when message sending fails.
 * @property topicName Two topics on a single account in the same region cannot have the same name. A topic name must start with an English letter or a digit, and can contain English letters, digits, and hyphens, with the length not exceeding 256 characters.
 */
public data class GetTopicSubscriptionsSubscription(
    public val endpoint: String,
    public val filterTag: String,
    public val id: String,
    public val name: String,
    public val notifyContentFormat: String,
    public val notifyStrategy: String,
    public val topicName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mns.outputs.GetTopicSubscriptionsSubscription): GetTopicSubscriptionsSubscription = GetTopicSubscriptionsSubscription(
            endpoint = javaType.endpoint(),
            filterTag = javaType.filterTag(),
            id = javaType.id(),
            name = javaType.name(),
            notifyContentFormat = javaType.notifyContentFormat(),
            notifyStrategy = javaType.notifyStrategy(),
            topicName = javaType.topicName(),
        )
    }
}
