@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTopics.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property namePrefix
 * @property names A list of topic names.
 * @property outputFile
 * @property topics A list of topics. Each element contains the following attributes:
 */
public data class GetTopicsResult(
    public val id: String,
    public val namePrefix: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val topics: List<GetTopicsTopic>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mns.outputs.GetTopicsResult): GetTopicsResult = GetTopicsResult(
            id = javaType.id(),
            namePrefix = javaType.namePrefix().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            topics = javaType.topics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.mns.kotlin.outputs.GetTopicsTopic.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
