@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mns.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The id of the topic. The value is set to `name`.
 * @property loggingEnabled Whether to enable logging.
 * @property maximumMessageSize This indicates the maximum length, in bytes, of any message body sent to the topic.
 * @property name The name of the topic.
 */
public data class GetTopicsTopic(
    public val id: String,
    public val loggingEnabled: Boolean,
    public val maximumMessageSize: Int,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.mns.outputs.GetTopicsTopic): GetTopicsTopic =
            GetTopicsTopic(
                id = javaType.id(),
                loggingEnabled = javaType.loggingEnabled(),
                maximumMessageSize = javaType.maximumMessageSize(),
                name = javaType.name(),
            )
    }
}
