@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin

import com.pulumi.alicloud.mongodb.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a MongoDB Account resource.
 * For information about MongoDB Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/en/doc-detail/62154.html).
 * > **NOTE:** Available since v1.148.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.mongodb.getZones({});
 * const index = _default.then(_default => _default.zones).length.then(length => length - 1);
 * const zoneId = _default.then(_default => _default.zones[index].id);
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: zoneId,
 * });
 * const defaultInstance = new alicloud.mongodb.Instance("default", {
 *     engineVersion: "4.2",
 *     dbInstanceClass: "dds.mongo.mid",
 *     dbInstanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     securityIpLists: [
 *         "10.168.1.12",
 *         "100.69.7.112",
 *     ],
 *     name: name,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultAccount = new alicloud.mongodb.Account("default", {
 *     accountName: "root",
 *     accountPassword: "Example_123",
 *     instanceId: defaultInstance.id,
 *     accountDescription: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.mongodb.get_zones()
 * index = len(default.zones) - 1
 * zone_id = default.zones[index].id
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=zone_id)
 * default_instance = alicloud.mongodb.Instance("default",
 *     engine_version="4.2",
 *     db_instance_class="dds.mongo.mid",
 *     db_instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     security_ip_lists=[
 *         "10.168.1.12",
 *         "100.69.7.112",
 *     ],
 *     name=name,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_account = alicloud.mongodb.Account("default",
 *     account_name="root",
 *     account_password="Example_123",
 *     instance_id=default_instance.id,
 *     account_description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.MongoDB.GetZones.Invoke();
 *     var index = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length.Apply(length => length - 1);
 *     var zoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)[index].Id);
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = zoneId,
 *     });
 *     var defaultInstance = new AliCloud.MongoDB.Instance("default", new()
 *     {
 *         EngineVersion = "4.2",
 *         DbInstanceClass = "dds.mongo.mid",
 *         DbInstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityIpLists = new[]
 *         {
 *             "10.168.1.12",
 *             "100.69.7.112",
 *         },
 *         Name = name,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultAccount = new AliCloud.MongoDB.Account("default", new()
 *     {
 *         AccountName = "root",
 *         AccountPassword = "Example_123",
 *         InstanceId = defaultInstance.Id,
 *         AccountDescription = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := mongodb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		index := pulumi.Float64(len(_default.Zones)) - 1
 * 		zoneId := _default.Zones[index].Id
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := mongodb.NewInstance(ctx, "default", &mongodb.InstanceArgs{
 * 			EngineVersion:     pulumi.String("4.2"),
 * 			DbInstanceClass:   pulumi.String("dds.mongo.mid"),
 * 			DbInstanceStorage: pulumi.Int(10),
 * 			VswitchId:         defaultSwitch.ID(),
 * 			SecurityIpLists: pulumi.StringArray{
 * 				pulumi.String("10.168.1.12"),
 * 				pulumi.String("100.69.7.112"),
 * 			},
 * 			Name: pulumi.String(name),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mongodb.NewAccount(ctx, "default", &mongodb.AccountArgs{
 * 			AccountName:        pulumi.String("root"),
 * 			AccountPassword:    pulumi.String("Example_123"),
 * 			InstanceId:         defaultInstance.ID(),
 * 			AccountDescription: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mongodb.MongodbFunctions;
 * import com.pulumi.alicloud.mongodb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.mongodb.Instance;
 * import com.pulumi.alicloud.mongodb.InstanceArgs;
 * import com.pulumi.alicloud.mongodb.Account;
 * import com.pulumi.alicloud.mongodb.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = MongodbFunctions.getZones();
 *         final var index = default_.zones().length() - 1;
 *         final var zoneId = default_.zones()[index].id();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(zoneId)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .engineVersion("4.2")
 *             .dbInstanceClass("dds.mongo.mid")
 *             .dbInstanceStorage(10)
 *             .vswitchId(defaultSwitch.id())
 *             .securityIpLists(
 *                 "10.168.1.12",
 *                 "100.69.7.112")
 *             .name(name)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .accountName("root")
 *             .accountPassword("Example_123")
 *             .instanceId(defaultInstance.id())
 *             .accountDescription(name)
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MongoDB Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mongodb/account:Account example <instance_id>:<account_name>
 * ```
 * @property accountDescription The description of the account.
 * * The description must start with a letter, and cannot start with `http://` or `https://`.
 * * It must be `2` to `256` characters in length, and can contain letters, digits, underscores (_), and hyphens (-).
 * @property accountName The name of the account. Valid values: `root`.
 * @property accountPassword The Password of the Account.
 * * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `!#$%^&*()_+-=`.
 * * The password must be `8` to `32` characters in length.
 * @property instanceId The ID of the instance.
 */
public data class AccountArgs(
    public val accountDescription: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val accountPassword: Output<String>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.AccountArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.AccountArgs =
        com.pulumi.alicloud.mongodb.AccountArgs.builder()
            .accountDescription(accountDescription?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountDescription: Output<String>? = null

    private var accountName: Output<String>? = null

    private var accountPassword: Output<String>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value The description of the account.
     * * The description must start with a letter, and cannot start with `http://` or `https://`.
     * * It must be `2` to `256` characters in length, and can contain letters, digits, underscores (_), and hyphens (-).
     */
    @JvmName("nrggyjkkprtvmttf")
    public suspend fun accountDescription(`value`: Output<String>) {
        this.accountDescription = value
    }

    /**
     * @param value The name of the account. Valid values: `root`.
     */
    @JvmName("mmdkamjnrppbkned")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The Password of the Account.
     * * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `!#$%^&*()_+-=`.
     * * The password must be `8` to `32` characters in length.
     */
    @JvmName("ytytpwjnwnegyuqm")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("ttpscuypjmkonsvo")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The description of the account.
     * * The description must start with a letter, and cannot start with `http://` or `https://`.
     * * It must be `2` to `256` characters in length, and can contain letters, digits, underscores (_), and hyphens (-).
     */
    @JvmName("tsebaqmjxdyrrsgc")
    public suspend fun accountDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountDescription = mapped
    }

    /**
     * @param value The name of the account. Valid values: `root`.
     */
    @JvmName("ahiyywlhxdwflwid")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The Password of the Account.
     * * The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `!#$%^&*()_+-=`.
     * * The password must be `8` to `32` characters in length.
     */
    @JvmName("spnpujqyadewxggh")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("osljpvuopowkmhlp")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountDescription = accountDescription,
        accountName = accountName,
        accountPassword = accountPassword,
        instanceId = instanceId,
    )
}
