@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AuditPolicy].
 */
@PulumiTagMarker
public class AuditPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuditPolicyArgs = AuditPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuditPolicyArgsBuilder.() -> Unit) {
        val builder = AuditPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AuditPolicy {
        val builtJavaResource = com.pulumi.alicloud.mongodb.AuditPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AuditPolicy(builtJavaResource)
    }
}

/**
 * Provides a MongoDB Audit Policy resource.
 * For information about MongoDB Audit Policy and how to use it, see [What is Audit Policy](https://www.alibabacloud.com/help/doc-detail/131941.html).
 * > **NOTE:** Available since v1.148.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.mongodb.getZones({});
 * const index = _default.then(_default => _default.zones).length.then(length => length - 1);
 * const zoneId = _default.then(_default => _default.zones[index].id);
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: zoneId,
 * });
 * const defaultInstance = new alicloud.mongodb.Instance("default", {
 *     engineVersion: "4.2",
 *     dbInstanceClass: "dds.mongo.mid",
 *     dbInstanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     securityIpLists: [
 *         "10.168.1.12",
 *         "100.69.7.112",
 *     ],
 *     name: name,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultAuditPolicy = new alicloud.mongodb.AuditPolicy("default", {
 *     dbInstanceId: defaultInstance.id,
 *     auditStatus: "disabled",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.mongodb.get_zones()
 * index = len(default.zones) - 1
 * zone_id = default.zones[index].id
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=zone_id)
 * default_instance = alicloud.mongodb.Instance("default",
 *     engine_version="4.2",
 *     db_instance_class="dds.mongo.mid",
 *     db_instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     security_ip_lists=[
 *         "10.168.1.12",
 *         "100.69.7.112",
 *     ],
 *     name=name,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_audit_policy = alicloud.mongodb.AuditPolicy("default",
 *     db_instance_id=default_instance.id,
 *     audit_status="disabled")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.MongoDB.GetZones.Invoke();
 *     var index = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length.Apply(length => length - 1);
 *     var zoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)[index].Id);
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = zoneId,
 *     });
 *     var defaultInstance = new AliCloud.MongoDB.Instance("default", new()
 *     {
 *         EngineVersion = "4.2",
 *         DbInstanceClass = "dds.mongo.mid",
 *         DbInstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityIpLists = new[]
 *         {
 *             "10.168.1.12",
 *             "100.69.7.112",
 *         },
 *         Name = name,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultAuditPolicy = new AliCloud.MongoDB.AuditPolicy("default", new()
 *     {
 *         DbInstanceId = defaultInstance.Id,
 *         AuditStatus = "disabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := mongodb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		index := pulumi.Float64(len(_default.Zones)) - 1
 * 		zoneId := _default.Zones[index].Id
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := mongodb.NewInstance(ctx, "default", &mongodb.InstanceArgs{
 * 			EngineVersion:     pulumi.String("4.2"),
 * 			DbInstanceClass:   pulumi.String("dds.mongo.mid"),
 * 			DbInstanceStorage: pulumi.Int(10),
 * 			VswitchId:         defaultSwitch.ID(),
 * 			SecurityIpLists: pulumi.StringArray{
 * 				pulumi.String("10.168.1.12"),
 * 				pulumi.String("100.69.7.112"),
 * 			},
 * 			Name: pulumi.String(name),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mongodb.NewAuditPolicy(ctx, "default", &mongodb.AuditPolicyArgs{
 * 			DbInstanceId: defaultInstance.ID(),
 * 			AuditStatus:  pulumi.String("disabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mongodb.MongodbFunctions;
 * import com.pulumi.alicloud.mongodb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.mongodb.Instance;
 * import com.pulumi.alicloud.mongodb.InstanceArgs;
 * import com.pulumi.alicloud.mongodb.AuditPolicy;
 * import com.pulumi.alicloud.mongodb.AuditPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = MongodbFunctions.getZones();
 *         final var index = default_.zones().length() - 1;
 *         final var zoneId = default_.zones()[index].id();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(zoneId)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .engineVersion("4.2")
 *             .dbInstanceClass("dds.mongo.mid")
 *             .dbInstanceStorage(10)
 *             .vswitchId(defaultSwitch.id())
 *             .securityIpLists(
 *                 "10.168.1.12",
 *                 "100.69.7.112")
 *             .name(name)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var defaultAuditPolicy = new AuditPolicy("defaultAuditPolicy", AuditPolicyArgs.builder()
 *             .dbInstanceId(defaultInstance.id())
 *             .auditStatus("disabled")
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MongoDB Audit Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mongodb/auditPolicy:AuditPolicy example <db_instance_id>
 * ```
 */
public class AuditPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.mongodb.AuditPolicy,
) : KotlinCustomResource(javaResource, AuditPolicyMapper) {
    /**
     * The status of the audit log. Valid values: `disabled`, `enable`.
     */
    public val auditStatus: Output<String>
        get() = javaResource.auditStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val dbInstanceId: Output<String>
        get() = javaResource.dbInstanceId().applyValue({ args0 -> args0 })

    /**
     * The retention period of audit logs. Valid values: `1` to `30`. Default value: `30`.
     */
    public val storagePeriod: Output<Int>?
        get() = javaResource.storagePeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AuditPolicyMapper : ResourceMapper<AuditPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mongodb.AuditPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AuditPolicy = AuditPolicy(
        javaResource as
            com.pulumi.alicloud.mongodb.AuditPolicy,
    )
}

/**
 * @see [AuditPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AuditPolicy].
 */
public suspend fun auditPolicy(name: String, block: suspend AuditPolicyResourceBuilder.() -> Unit): AuditPolicy {
    val builder = AuditPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AuditPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun auditPolicy(name: String): AuditPolicy {
    val builder = AuditPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
