@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin

import com.pulumi.alicloud.mongodb.kotlin.outputs.InstanceParameter
import com.pulumi.alicloud.mongodb.kotlin.outputs.InstanceReplicaSet
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.mongodb.kotlin.outputs.InstanceParameter.Companion.toKotlin as instanceParameterToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.InstanceReplicaSet.Companion.toKotlin as instanceReplicaSetToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.mongodb.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a MongoDB instance resource supports replica set instances only. the MongoDB provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/doc-detail/26558.htm)
 * > **NOTE:** Available since v1.37.0.
 * > **NOTE:**  The following regions don't support create Classic network MongoDB instance.
 * [`cn-zhangjiakou`,`cn-huhehaote`,`ap-southeast-3`,`ap-southeast-5`,`me-east-1`,`ap-northeast-1`,`eu-west-1`]
 * > **NOTE:**  Create MongoDB instance or change instance type and storage would cost 5~10 minutes. Please make full preparation
 * ## Example Usage
 * ### Create a Mongodb instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.mongodb.getZones({});
 * const index = _default.then(_default => _default.zones).length.then(length => length - 1);
 * const zoneId = _default.then(_default => _default.zones[index].id);
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: zoneId,
 * });
 * const defaultInstance = new alicloud.mongodb.Instance("default", {
 *     engineVersion: "4.2",
 *     dbInstanceClass: "dds.mongo.mid",
 *     dbInstanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     securityIpLists: [
 *         "10.168.1.12",
 *         "100.69.7.112",
 *     ],
 *     name: name,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.mongodb.get_zones()
 * index = len(default.zones) - 1
 * zone_id = default.zones[index].id
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=zone_id)
 * default_instance = alicloud.mongodb.Instance("default",
 *     engine_version="4.2",
 *     db_instance_class="dds.mongo.mid",
 *     db_instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     security_ip_lists=[
 *         "10.168.1.12",
 *         "100.69.7.112",
 *     ],
 *     name=name,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.MongoDB.GetZones.Invoke();
 *     var index = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length.Apply(length => length - 1);
 *     var zoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)[index].Id);
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = zoneId,
 *     });
 *     var defaultInstance = new AliCloud.MongoDB.Instance("default", new()
 *     {
 *         EngineVersion = "4.2",
 *         DbInstanceClass = "dds.mongo.mid",
 *         DbInstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityIpLists = new[]
 *         {
 *             "10.168.1.12",
 *             "100.69.7.112",
 *         },
 *         Name = name,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := mongodb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		index := pulumi.Float64(len(_default.Zones)) - 1
 * 		zoneId := _default.Zones[index].Id
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mongodb.NewInstance(ctx, "default", &mongodb.InstanceArgs{
 * 			EngineVersion:     pulumi.String("4.2"),
 * 			DbInstanceClass:   pulumi.String("dds.mongo.mid"),
 * 			DbInstanceStorage: pulumi.Int(10),
 * 			VswitchId:         defaultSwitch.ID(),
 * 			SecurityIpLists: pulumi.StringArray{
 * 				pulumi.String("10.168.1.12"),
 * 				pulumi.String("100.69.7.112"),
 * 			},
 * 			Name: pulumi.String(name),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mongodb.MongodbFunctions;
 * import com.pulumi.alicloud.mongodb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.mongodb.Instance;
 * import com.pulumi.alicloud.mongodb.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = MongodbFunctions.getZones();
 *         final var index = default_.zones().length() - 1;
 *         final var zoneId = default_.zones()[index].id();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(zoneId)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .engineVersion("4.2")
 *             .dbInstanceClass("dds.mongo.mid")
 *             .dbInstanceStorage(10)
 *             .vswitchId(defaultSwitch.id())
 *             .securityIpLists(
 *                 "10.168.1.12",
 *                 "100.69.7.112")
 *             .name(name)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing mongodb module
 * to create a MongoDB instance resource one-click.
 * ## Import
 * MongoDB instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mongodb/instance:Instance example dds-bp1291daeda44194
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.mongodb.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Password of the root account. It is a string of 6 to 32 characters and is composed of letters, numbers, and underlines.
     */
    public val accountPassword: Output<String>?
        get() = javaResource.accountPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Auto renew for prepaid. Default value: `false`. Valid values: `true`, `false`.
     * > **NOTE:** The start time to the end time must be 1 hour. For example, the MaintainStartTime is 01:00Z, then the MaintainEndTime must be 02:00Z.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The frequency at which high-frequency backups are created. Valid values: `-1`, `15`, `30`, `60`, `120`, `180`, `240`, `360`, `480`, `720`.
     */
    public val backupInterval: Output<String>
        get() = javaResource.backupInterval().applyValue({ args0 -> args0 })

    /**
     * MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    public val backupPeriods: Output<List<String>>
        get() = javaResource.backupPeriods().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The retention period of full backups.
     */
    public val backupRetentionPeriod: Output<Int>
        get() = javaResource.backupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * MongoDB instance backup time. It is required when `backup_period` was existed. In the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. If not set, the system will return a default, like "23:00Z-24:00Z".
     */
    public val backupTime: Output<String>
        get() = javaResource.backupTime().applyValue({ args0 -> args0 })

    /**
     * The ID of the encryption key.
     */
    public val cloudDiskEncryptionKey: Output<String>?
        get() = javaResource.cloudDiskEncryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance specification. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
     */
    public val dbInstanceClass: Output<String>
        get() = javaResource.dbInstanceClass().applyValue({ args0 -> args0 })

    /**
     * User-defined DB instance storage space.Unit: GB. Value range:
     * - Custom storage space.
     * - 10-GB increments.
     */
    public val dbInstanceStorage: Output<Int>
        get() = javaResource.dbInstanceStorage().applyValue({ args0 -> args0 })

    /**
     * The time when the changed configurations take effect. Valid values: `Immediately`, `MaintainTime`.
     */
    public val effectiveTime: Output<String>?
        get() = javaResource.effectiveTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable cloud disk encryption. Default value: `false`. Valid values: `true`, `false`.
     */
    public val encrypted: Output<Boolean>?
        get() = javaResource.encrypted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the custom key.
     */
    public val encryptionKey: Output<String>
        get() = javaResource.encryptionKey().applyValue({ args0 -> args0 })

    /**
     * The encryption method. **NOTE:** `encryptor_name` is valid only when `tde_status` is set to `enabled`.
     */
    public val encryptorName: Output<String>
        get() = javaResource.encryptorName().applyValue({ args0 -> args0 })

    /**
     * Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/61763.htm) `EngineVersion`. **NOTE:** From version 1.225.0, `engine_version` can be modified.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Configure the zone where the hidden node is located to deploy multiple zones. **NOTE:** This parameter value cannot be the same as `zone_id` and `secondary_zone_id` parameter values.
     */
    public val hiddenZoneId: Output<String>?
        get() = javaResource.hiddenZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing method of the instance. Default value: `PostPaid`. Valid values: `PrePaid`, `PostPaid`. **NOTE:** It can be modified from `PostPaid` to `PrePaid` after version 1.63.0.
     */
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * An KMS encrypts password used to a instance. If the `account_password` is filled in, this field will be ignored.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time).
     */
    public val maintainEndTime: Output<String>
        get() = javaResource.maintainEndTime().applyValue({ args0 -> args0 })

    /**
     * The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time).
     */
    public val maintainStartTime: Output<String>
        get() = javaResource.maintainStartTime().applyValue({ args0 -> args0 })

    /**
     * The name of DB instance. It must be 2 to 256 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network type of the instance. Valid values:`Classic`, `VPC`.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * The type of configuration changes performed. Default value: `DOWNGRADE`. Valid values:
     * - `UPGRADE`: The specifications are upgraded.
     * - `DOWNGRADE`: The specifications are downgraded.
     * **NOTE:** `order_type` is only applicable to instances when `instance_charge_type` is `PrePaid`.
     */
    public val orderType: Output<String>?
        get() = javaResource.orderType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
     */
    public val parameters: Output<List<InstanceParameter>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceParameterToKotlin(args0)
                })
            })
        })

    /**
     * The duration that you will buy DB instance (in month). It is valid when `instance_charge_type` is `PrePaid`. Default value: `1`. Valid values: [1~9], 12, 24, 36.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The provisioned IOPS. Valid values: `0` to `50000`.
     */
    public val provisionedIops: Output<Int>?
        get() = javaResource.provisionedIops().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of read-only nodes in the replica set instance. Default value: 0. Valid values: 0 to 5.
     */
    public val readonlyReplicas: Output<Int>
        get() = javaResource.readonlyReplicas().applyValue({ args0 -> args0 })

    /**
     * The name of the mongo replica set.
     */
    public val replicaSetName: Output<String>
        get() = javaResource.replicaSetName().applyValue({ args0 -> args0 })

    /**
     * Replica set instance information.
     */
    public val replicaSets: Output<List<InstanceReplicaSet>>
        get() = javaResource.replicaSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceReplicaSetToKotlin(args0)
                })
            })
        })

    /**
     * Number of replica set nodes. Valid values: `1`, `3`, `5`, `7`.
     */
    public val replicationFactor: Output<Int>
        get() = javaResource.replicationFactor().applyValue({ args0 -> args0 })

    /**
     * The ID of the Resource Group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Instance data backup retention days. Available since v1.42.0.
     */
    public val retentionPeriod: Output<Int>
        get() = javaResource.retentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The Alibaba Cloud Resource Name (ARN) of the specified Resource Access Management (RAM) role.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Configure the available area where the slave node (Secondary node) is located to realize multi-available area deployment. **NOTE:** This parameter value cannot be the same as `zone_id` and `hidden_zone_id` parameter values.
     */
    public val secondaryZoneId: Output<String>?
        get() = javaResource.secondaryZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Security Group ID of ECS.
     */
    public val securityGroupId: Output<String>?
        get() = javaResource.securityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    public val securityIpLists: Output<List<String>>
        get() = javaResource.securityIpLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The snapshot backup type. Default value: `Standard`. Valid values:
     * - `Standard`: standard backup.
     * - `Flash `: single-digit second backup.
     */
    public val snapshotBackupType: Output<String>
        get() = javaResource.snapshotBackupType().applyValue({ args0 -> args0 })

    /**
     * Actions performed on SSL functions. Valid values:
     * - `Open`: turn on SSL encryption.
     * - `Close`: turn off SSL encryption.
     * - `Update`: update SSL certificate.
     */
    public val sslAction: Output<String>?
        get() = javaResource.sslAction().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Status of the SSL feature.
     */
    public val sslStatus: Output<String>
        get() = javaResource.sslStatus().applyValue({ args0 -> args0 })

    /**
     * The storage engine of the instance. Default value: `WiredTiger`. Valid values: `WiredTiger`, `RocksDB`.
     */
    public val storageEngine: Output<String>
        get() = javaResource.storageEngine().applyValue({ args0 -> args0 })

    /**
     * The storage type of the instance. Valid values: `cloud_essd1`, `cloud_essd2`, `cloud_essd3`, `cloud_auto`, `local_ssd`. **NOTE:** From version 1.229.0, `storage_type` can be modified. However, `storage_type` can only be modified to `cloud_auto`.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The TDE(Transparent Data Encryption) status. Valid values: `enabled`.
     */
    public val tdeStatus: Output<String>
        get() = javaResource.tdeStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The virtual switch ID to launch DB instances in one VPC.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The Zone to launch the DB instance. it supports multiple zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in one of them.
     * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mongodb.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.mongodb.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
