@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin

import com.pulumi.alicloud.mongodb.InstanceArgs.builder
import com.pulumi.alicloud.mongodb.kotlin.inputs.InstanceParameterArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.InstanceParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MongoDB instance resource supports replica set instances only. the MongoDB provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/doc-detail/26558.htm)
 * > **NOTE:** Available since v1.37.0.
 * > **NOTE:**  The following regions don't support create Classic network MongoDB instance.
 * [`cn-zhangjiakou`,`cn-huhehaote`,`ap-southeast-3`,`ap-southeast-5`,`me-east-1`,`ap-northeast-1`,`eu-west-1`]
 * > **NOTE:**  Create MongoDB instance or change instance type and storage would cost 5~10 minutes. Please make full preparation
 * ## Example Usage
 * ### Create a Mongodb instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.mongodb.getZones({});
 * const index = _default.then(_default => _default.zones).length.then(length => length - 1);
 * const zoneId = _default.then(_default => _default.zones[index].id);
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: zoneId,
 * });
 * const defaultInstance = new alicloud.mongodb.Instance("default", {
 *     engineVersion: "4.2",
 *     dbInstanceClass: "dds.mongo.mid",
 *     dbInstanceStorage: 10,
 *     vswitchId: defaultSwitch.id,
 *     securityIpLists: [
 *         "10.168.1.12",
 *         "100.69.7.112",
 *     ],
 *     name: name,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.mongodb.get_zones()
 * index = len(default.zones) - 1
 * zone_id = default.zones[index].id
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=zone_id)
 * default_instance = alicloud.mongodb.Instance("default",
 *     engine_version="4.2",
 *     db_instance_class="dds.mongo.mid",
 *     db_instance_storage=10,
 *     vswitch_id=default_switch.id,
 *     security_ip_lists=[
 *         "10.168.1.12",
 *         "100.69.7.112",
 *     ],
 *     name=name,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.MongoDB.GetZones.Invoke();
 *     var index = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length.Apply(length => length - 1);
 *     var zoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)[index].Id);
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = zoneId,
 *     });
 *     var defaultInstance = new AliCloud.MongoDB.Instance("default", new()
 *     {
 *         EngineVersion = "4.2",
 *         DbInstanceClass = "dds.mongo.mid",
 *         DbInstanceStorage = 10,
 *         VswitchId = defaultSwitch.Id,
 *         SecurityIpLists = new[]
 *         {
 *             "10.168.1.12",
 *             "100.69.7.112",
 *         },
 *         Name = name,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := mongodb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		index := pulumi.Float64(len(_default.Zones)) - 1
 * 		zoneId := _default.Zones[index].Id
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mongodb.NewInstance(ctx, "default", &mongodb.InstanceArgs{
 * 			EngineVersion:     pulumi.String("4.2"),
 * 			DbInstanceClass:   pulumi.String("dds.mongo.mid"),
 * 			DbInstanceStorage: pulumi.Int(10),
 * 			VswitchId:         defaultSwitch.ID(),
 * 			SecurityIpLists: pulumi.StringArray{
 * 				pulumi.String("10.168.1.12"),
 * 				pulumi.String("100.69.7.112"),
 * 			},
 * 			Name: pulumi.String(name),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mongodb.MongodbFunctions;
 * import com.pulumi.alicloud.mongodb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.mongodb.Instance;
 * import com.pulumi.alicloud.mongodb.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = MongodbFunctions.getZones();
 *         final var index = default_.zones().length() - 1;
 *         final var zoneId = default_.zones()[index].id();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(zoneId)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .engineVersion("4.2")
 *             .dbInstanceClass("dds.mongo.mid")
 *             .dbInstanceStorage(10)
 *             .vswitchId(defaultSwitch.id())
 *             .securityIpLists(
 *                 "10.168.1.12",
 *                 "100.69.7.112")
 *             .name(name)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing mongodb module
 * to create a MongoDB instance resource one-click.
 * ## Import
 * MongoDB instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mongodb/instance:Instance example dds-bp1291daeda44194
 * ```
 * @property accountPassword Password of the root account. It is a string of 6 to 32 characters and is composed of letters, numbers, and underlines.
 * @property autoRenew Auto renew for prepaid. Default value: `false`. Valid values: `true`, `false`.
 * > **NOTE:** The start time to the end time must be 1 hour. For example, the MaintainStartTime is 01:00Z, then the MaintainEndTime must be 02:00Z.
 * @property backupInterval The frequency at which high-frequency backups are created. Valid values: `-1`, `15`, `30`, `60`, `120`, `180`, `240`, `360`, `480`, `720`.
 * @property backupPeriods MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
 * @property backupRetentionPeriod The retention period of full backups.
 * @property backupTime MongoDB instance backup time. It is required when `backup_period` was existed. In the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. If not set, the system will return a default, like "23:00Z-24:00Z".
 * @property cloudDiskEncryptionKey The ID of the encryption key.
 * @property dbInstanceClass Instance specification. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
 * @property dbInstanceStorage User-defined DB instance storage space.Unit: GB. Value range:
 * - Custom storage space.
 * - 10-GB increments.
 * @property effectiveTime The time when the changed configurations take effect. Valid values: `Immediately`, `MaintainTime`.
 * @property encrypted Whether to enable cloud disk encryption. Default value: `false`. Valid values: `true`, `false`.
 * @property encryptionKey The ID of the custom key.
 * @property encryptorName The encryption method. **NOTE:** `encryptor_name` is valid only when `tde_status` is set to `enabled`.
 * @property engineVersion Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/61763.htm) `EngineVersion`. **NOTE:** From version 1.225.0, `engine_version` can be modified.
 * @property hiddenZoneId Configure the zone where the hidden node is located to deploy multiple zones. **NOTE:** This parameter value cannot be the same as `zone_id` and `secondary_zone_id` parameter values.
 * @property instanceChargeType The billing method of the instance. Default value: `PostPaid`. Valid values: `PrePaid`, `PostPaid`. **NOTE:** It can be modified from `PostPaid` to `PrePaid` after version 1.63.0.
 * @property kmsEncryptedPassword An KMS encrypts password used to a instance. If the `account_password` is filled in, this field will be ignored.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property maintainEndTime The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time).
 * @property maintainStartTime The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time).
 * @property name The name of DB instance. It must be 2 to 256 characters in length.
 * @property networkType The network type of the instance. Valid values:`Classic`, `VPC`.
 * @property orderType The type of configuration changes performed. Default value: `DOWNGRADE`. Valid values:
 * - `UPGRADE`: The specifications are upgraded.
 * - `DOWNGRADE`: The specifications are downgraded.
 * **NOTE:** `order_type` is only applicable to instances when `instance_charge_type` is `PrePaid`.
 * @property parameters Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
 * @property period The duration that you will buy DB instance (in month). It is valid when `instance_charge_type` is `PrePaid`. Default value: `1`. Valid values: [1~9], 12, 24, 36.
 * @property provisionedIops The provisioned IOPS. Valid values: `0` to `50000`.
 * @property readonlyReplicas The number of read-only nodes in the replica set instance. Default value: 0. Valid values: 0 to 5.
 * @property replicationFactor Number of replica set nodes. Valid values: `1`, `3`, `5`, `7`.
 * @property resourceGroupId The ID of the Resource Group.
 * @property roleArn The Alibaba Cloud Resource Name (ARN) of the specified Resource Access Management (RAM) role.
 * @property secondaryZoneId Configure the available area where the slave node (Secondary node) is located to realize multi-available area deployment. **NOTE:** This parameter value cannot be the same as `zone_id` and `hidden_zone_id` parameter values.
 * @property securityGroupId The Security Group ID of ECS.
 * @property securityIpLists List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
 * @property snapshotBackupType The snapshot backup type. Default value: `Standard`. Valid values:
 * - `Standard`: standard backup.
 * - `Flash `: single-digit second backup.
 * @property sslAction Actions performed on SSL functions. Valid values:
 * - `Open`: turn on SSL encryption.
 * - `Close`: turn off SSL encryption.
 * - `Update`: update SSL certificate.
 * @property storageEngine The storage engine of the instance. Default value: `WiredTiger`. Valid values: `WiredTiger`, `RocksDB`.
 * @property storageType The storage type of the instance. Valid values: `cloud_essd1`, `cloud_essd2`, `cloud_essd3`, `cloud_auto`, `local_ssd`. **NOTE:** From version 1.229.0, `storage_type` can be modified. However, `storage_type` can only be modified to `cloud_auto`.
 * @property tags A mapping of tags to assign to the resource.
 * @property tdeStatus The TDE(Transparent Data Encryption) status. Valid values: `enabled`.
 * @property vpcId The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
 * @property vswitchId The virtual switch ID to launch DB instances in one VPC.
 * @property zoneId The Zone to launch the DB instance. it supports multiple zone.
 * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in one of them.
 * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
 */
public data class InstanceArgs(
    public val accountPassword: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val backupInterval: Output<String>? = null,
    public val backupPeriods: Output<List<String>>? = null,
    public val backupRetentionPeriod: Output<Int>? = null,
    public val backupTime: Output<String>? = null,
    public val cloudDiskEncryptionKey: Output<String>? = null,
    public val dbInstanceClass: Output<String>? = null,
    public val dbInstanceStorage: Output<Int>? = null,
    public val effectiveTime: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val encryptionKey: Output<String>? = null,
    public val encryptorName: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val hiddenZoneId: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val maintainEndTime: Output<String>? = null,
    public val maintainStartTime: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val orderType: Output<String>? = null,
    public val parameters: Output<List<InstanceParameterArgs>>? = null,
    public val period: Output<Int>? = null,
    public val provisionedIops: Output<Int>? = null,
    public val readonlyReplicas: Output<Int>? = null,
    public val replicationFactor: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val secondaryZoneId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val securityIpLists: Output<List<String>>? = null,
    public val snapshotBackupType: Output<String>? = null,
    public val sslAction: Output<String>? = null,
    public val storageEngine: Output<String>? = null,
    public val storageType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tdeStatus: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.InstanceArgs =
        com.pulumi.alicloud.mongodb.InstanceArgs.builder()
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .backupInterval(backupInterval?.applyValue({ args0 -> args0 }))
            .backupPeriods(backupPeriods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupRetentionPeriod(backupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .backupTime(backupTime?.applyValue({ args0 -> args0 }))
            .cloudDiskEncryptionKey(cloudDiskEncryptionKey?.applyValue({ args0 -> args0 }))
            .dbInstanceClass(dbInstanceClass?.applyValue({ args0 -> args0 }))
            .dbInstanceStorage(dbInstanceStorage?.applyValue({ args0 -> args0 }))
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .encryptorName(encryptorName?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .hiddenZoneId(hiddenZoneId?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .maintainEndTime(maintainEndTime?.applyValue({ args0 -> args0 }))
            .maintainStartTime(maintainStartTime?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .orderType(orderType?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .period(period?.applyValue({ args0 -> args0 }))
            .provisionedIops(provisionedIops?.applyValue({ args0 -> args0 }))
            .readonlyReplicas(readonlyReplicas?.applyValue({ args0 -> args0 }))
            .replicationFactor(replicationFactor?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .secondaryZoneId(secondaryZoneId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityIpLists(securityIpLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .snapshotBackupType(snapshotBackupType?.applyValue({ args0 -> args0 }))
            .sslAction(sslAction?.applyValue({ args0 -> args0 }))
            .storageEngine(storageEngine?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tdeStatus(tdeStatus?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var accountPassword: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var backupInterval: Output<String>? = null

    private var backupPeriods: Output<List<String>>? = null

    private var backupRetentionPeriod: Output<Int>? = null

    private var backupTime: Output<String>? = null

    private var cloudDiskEncryptionKey: Output<String>? = null

    private var dbInstanceClass: Output<String>? = null

    private var dbInstanceStorage: Output<Int>? = null

    private var effectiveTime: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var encryptionKey: Output<String>? = null

    private var encryptorName: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var hiddenZoneId: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var maintainEndTime: Output<String>? = null

    private var maintainStartTime: Output<String>? = null

    private var name: Output<String>? = null

    private var networkType: Output<String>? = null

    private var orderType: Output<String>? = null

    private var parameters: Output<List<InstanceParameterArgs>>? = null

    private var period: Output<Int>? = null

    private var provisionedIops: Output<Int>? = null

    private var readonlyReplicas: Output<Int>? = null

    private var replicationFactor: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var secondaryZoneId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityIpLists: Output<List<String>>? = null

    private var snapshotBackupType: Output<String>? = null

    private var sslAction: Output<String>? = null

    private var storageEngine: Output<String>? = null

    private var storageType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tdeStatus: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Password of the root account. It is a string of 6 to 32 characters and is composed of letters, numbers, and underlines.
     */
    @JvmName("meptbqyogrlhqouv")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value Auto renew for prepaid. Default value: `false`. Valid values: `true`, `false`.
     * > **NOTE:** The start time to the end time must be 1 hour. For example, the MaintainStartTime is 01:00Z, then the MaintainEndTime must be 02:00Z.
     */
    @JvmName("vaqrrjynbpcsdlpg")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The frequency at which high-frequency backups are created. Valid values: `-1`, `15`, `30`, `60`, `120`, `180`, `240`, `360`, `480`, `720`.
     */
    @JvmName("twxpyquxccudiqan")
    public suspend fun backupInterval(`value`: Output<String>) {
        this.backupInterval = value
    }

    /**
     * @param value MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("hebshnrucjfsaqvp")
    public suspend fun backupPeriods(`value`: Output<List<String>>) {
        this.backupPeriods = value
    }

    @JvmName("gywnfrijeemqhbdv")
    public suspend fun backupPeriods(vararg values: Output<String>) {
        this.backupPeriods = Output.all(values.asList())
    }

    /**
     * @param values MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("vijqmidebmwixqsl")
    public suspend fun backupPeriods(values: List<Output<String>>) {
        this.backupPeriods = Output.all(values)
    }

    /**
     * @param value The retention period of full backups.
     */
    @JvmName("hyijwolajqskwmmn")
    public suspend fun backupRetentionPeriod(`value`: Output<Int>) {
        this.backupRetentionPeriod = value
    }

    /**
     * @param value MongoDB instance backup time. It is required when `backup_period` was existed. In the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. If not set, the system will return a default, like "23:00Z-24:00Z".
     */
    @JvmName("vpaagfkcyknagqdj")
    public suspend fun backupTime(`value`: Output<String>) {
        this.backupTime = value
    }

    /**
     * @param value The ID of the encryption key.
     */
    @JvmName("ojxciydbcgmlhpjb")
    public suspend fun cloudDiskEncryptionKey(`value`: Output<String>) {
        this.cloudDiskEncryptionKey = value
    }

    /**
     * @param value Instance specification. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
     */
    @JvmName("alaqjqbmacnymhxx")
    public suspend fun dbInstanceClass(`value`: Output<String>) {
        this.dbInstanceClass = value
    }

    /**
     * @param value User-defined DB instance storage space.Unit: GB. Value range:
     * - Custom storage space.
     * - 10-GB increments.
     */
    @JvmName("rqhyfwodrnlcetun")
    public suspend fun dbInstanceStorage(`value`: Output<Int>) {
        this.dbInstanceStorage = value
    }

    /**
     * @param value The time when the changed configurations take effect. Valid values: `Immediately`, `MaintainTime`.
     */
    @JvmName("caljueltpyyyubwm")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value Whether to enable cloud disk encryption. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("namjipqaavuruqdy")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The ID of the custom key.
     */
    @JvmName("nckgelrwihmrjduj")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value The encryption method. **NOTE:** `encryptor_name` is valid only when `tde_status` is set to `enabled`.
     */
    @JvmName("cttlbbdxqydnurqv")
    public suspend fun encryptorName(`value`: Output<String>) {
        this.encryptorName = value
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/61763.htm) `EngineVersion`. **NOTE:** From version 1.225.0, `engine_version` can be modified.
     */
    @JvmName("amlgnvcxtncjoarq")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Configure the zone where the hidden node is located to deploy multiple zones. **NOTE:** This parameter value cannot be the same as `zone_id` and `secondary_zone_id` parameter values.
     */
    @JvmName("wtakhraurfsoaola")
    public suspend fun hiddenZoneId(`value`: Output<String>) {
        this.hiddenZoneId = value
    }

    /**
     * @param value The billing method of the instance. Default value: `PostPaid`. Valid values: `PrePaid`, `PostPaid`. **NOTE:** It can be modified from `PostPaid` to `PrePaid` after version 1.63.0.
     */
    @JvmName("fweojfopqdholrhd")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value An KMS encrypts password used to a instance. If the `account_password` is filled in, this field will be ignored.
     */
    @JvmName("thyfxxddhsctdsja")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("eoptycwxnajhpvmb")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time).
     */
    @JvmName("hdqoveoqgjhnpeth")
    public suspend fun maintainEndTime(`value`: Output<String>) {
        this.maintainEndTime = value
    }

    /**
     * @param value The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time).
     */
    @JvmName("acxwefbgxaslmhyf")
    public suspend fun maintainStartTime(`value`: Output<String>) {
        this.maintainStartTime = value
    }

    /**
     * @param value The name of DB instance. It must be 2 to 256 characters in length.
     */
    @JvmName("oecnuxbymtbpktvi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The network type of the instance. Valid values:`Classic`, `VPC`.
     */
    @JvmName("vvtlxbwknqrjpisf")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The type of configuration changes performed. Default value: `DOWNGRADE`. Valid values:
     * - `UPGRADE`: The specifications are upgraded.
     * - `DOWNGRADE`: The specifications are downgraded.
     * **NOTE:** `order_type` is only applicable to instances when `instance_charge_type` is `PrePaid`.
     */
    @JvmName("houoeuhaejrdhtqw")
    public suspend fun orderType(`value`: Output<String>) {
        this.orderType = value
    }

    /**
     * @param value Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
     */
    @JvmName("rjqfoavshshhhqwe")
    public suspend fun parameters(`value`: Output<List<InstanceParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("dguysnkinqfbmfoh")
    public suspend fun parameters(vararg values: Output<InstanceParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
     */
    @JvmName("ibuanwkgwtsnpogt")
    public suspend fun parameters(values: List<Output<InstanceParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The duration that you will buy DB instance (in month). It is valid when `instance_charge_type` is `PrePaid`. Default value: `1`. Valid values: [1~9], 12, 24, 36.
     */
    @JvmName("ksuurxlmwkldbhmq")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The provisioned IOPS. Valid values: `0` to `50000`.
     */
    @JvmName("aesgfhnermarjgmk")
    public suspend fun provisionedIops(`value`: Output<Int>) {
        this.provisionedIops = value
    }

    /**
     * @param value The number of read-only nodes in the replica set instance. Default value: 0. Valid values: 0 to 5.
     */
    @JvmName("axxvoxuuvimrmhig")
    public suspend fun readonlyReplicas(`value`: Output<Int>) {
        this.readonlyReplicas = value
    }

    /**
     * @param value Number of replica set nodes. Valid values: `1`, `3`, `5`, `7`.
     */
    @JvmName("wuourqyvoiebvdys")
    public suspend fun replicationFactor(`value`: Output<Int>) {
        this.replicationFactor = value
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("fefyqbeqdojduvvq")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the specified Resource Access Management (RAM) role.
     */
    @JvmName("bucxrvbrbtylgblq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Configure the available area where the slave node (Secondary node) is located to realize multi-available area deployment. **NOTE:** This parameter value cannot be the same as `zone_id` and `hidden_zone_id` parameter values.
     */
    @JvmName("rdgurgyqmhqlkqwh")
    public suspend fun secondaryZoneId(`value`: Output<String>) {
        this.secondaryZoneId = value
    }

    /**
     * @param value The Security Group ID of ECS.
     */
    @JvmName("dmoggjnsgpkprraf")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("begvojkcbyucmxki")
    public suspend fun securityIpLists(`value`: Output<List<String>>) {
        this.securityIpLists = value
    }

    @JvmName("kcxwqsddlunvwhkv")
    public suspend fun securityIpLists(vararg values: Output<String>) {
        this.securityIpLists = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("mfcmtujupsyhisdk")
    public suspend fun securityIpLists(values: List<Output<String>>) {
        this.securityIpLists = Output.all(values)
    }

    /**
     * @param value The snapshot backup type. Default value: `Standard`. Valid values:
     * - `Standard`: standard backup.
     * - `Flash `: single-digit second backup.
     */
    @JvmName("rrdrnbyuihnilsjo")
    public suspend fun snapshotBackupType(`value`: Output<String>) {
        this.snapshotBackupType = value
    }

    /**
     * @param value Actions performed on SSL functions. Valid values:
     * - `Open`: turn on SSL encryption.
     * - `Close`: turn off SSL encryption.
     * - `Update`: update SSL certificate.
     */
    @JvmName("jgdrqoljbfjwawnm")
    public suspend fun sslAction(`value`: Output<String>) {
        this.sslAction = value
    }

    /**
     * @param value The storage engine of the instance. Default value: `WiredTiger`. Valid values: `WiredTiger`, `RocksDB`.
     */
    @JvmName("ydeynlxutuknqdht")
    public suspend fun storageEngine(`value`: Output<String>) {
        this.storageEngine = value
    }

    /**
     * @param value The storage type of the instance. Valid values: `cloud_essd1`, `cloud_essd2`, `cloud_essd3`, `cloud_auto`, `local_ssd`. **NOTE:** From version 1.229.0, `storage_type` can be modified. However, `storage_type` can only be modified to `cloud_auto`.
     */
    @JvmName("odxjqwiouvdesajd")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("stnekukfumcaovro")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The TDE(Transparent Data Encryption) status. Valid values: `enabled`.
     */
    @JvmName("vdvsimhxmcdwxsvk")
    public suspend fun tdeStatus(`value`: Output<String>) {
        this.tdeStatus = value
    }

    /**
     * @param value The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
     */
    @JvmName("dcofhmrwwasqknne")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC.
     */
    @JvmName("mpsuheprhhhojvhy")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the DB instance. it supports multiple zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in one of them.
     * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
     */
    @JvmName("gyrtxodinajgyjvy")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Password of the root account. It is a string of 6 to 32 characters and is composed of letters, numbers, and underlines.
     */
    @JvmName("usbjulkpckoroviu")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value Auto renew for prepaid. Default value: `false`. Valid values: `true`, `false`.
     * > **NOTE:** The start time to the end time must be 1 hour. For example, the MaintainStartTime is 01:00Z, then the MaintainEndTime must be 02:00Z.
     */
    @JvmName("euepaukmishvsgnb")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The frequency at which high-frequency backups are created. Valid values: `-1`, `15`, `30`, `60`, `120`, `180`, `240`, `360`, `480`, `720`.
     */
    @JvmName("yoyoatjbhfhubxjm")
    public suspend fun backupInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupInterval = mapped
    }

    /**
     * @param value MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("glfaccjvvopoeeyd")
    public suspend fun backupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param values MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("auideqlprdsxohpu")
    public suspend fun backupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPeriods = mapped
    }

    /**
     * @param value The retention period of full backups.
     */
    @JvmName("yibwffraqdnbptih")
    public suspend fun backupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPeriod = mapped
    }

    /**
     * @param value MongoDB instance backup time. It is required when `backup_period` was existed. In the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. If not set, the system will return a default, like "23:00Z-24:00Z".
     */
    @JvmName("pcarroywijlaqhkx")
    public suspend fun backupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupTime = mapped
    }

    /**
     * @param value The ID of the encryption key.
     */
    @JvmName("yhpmftvhuqyeondd")
    public suspend fun cloudDiskEncryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudDiskEncryptionKey = mapped
    }

    /**
     * @param value Instance specification. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
     */
    @JvmName("oimbevtfbgmyhxfs")
    public suspend fun dbInstanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceClass = mapped
    }

    /**
     * @param value User-defined DB instance storage space.Unit: GB. Value range:
     * - Custom storage space.
     * - 10-GB increments.
     */
    @JvmName("jgkpagcghxhvejlp")
    public suspend fun dbInstanceStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceStorage = mapped
    }

    /**
     * @param value The time when the changed configurations take effect. Valid values: `Immediately`, `MaintainTime`.
     */
    @JvmName("fhlyveslvteakhnj")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value Whether to enable cloud disk encryption. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("thtfykmpjgrqbmql")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The ID of the custom key.
     */
    @JvmName("fmlgwwfjpmblyeyy")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value The encryption method. **NOTE:** `encryptor_name` is valid only when `tde_status` is set to `enabled`.
     */
    @JvmName("omkcdhyhboswighm")
    public suspend fun encryptorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptorName = mapped
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/61763.htm) `EngineVersion`. **NOTE:** From version 1.225.0, `engine_version` can be modified.
     */
    @JvmName("fuhlpxgrmgikpjlt")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Configure the zone where the hidden node is located to deploy multiple zones. **NOTE:** This parameter value cannot be the same as `zone_id` and `secondary_zone_id` parameter values.
     */
    @JvmName("qmhqvqrymlavirgd")
    public suspend fun hiddenZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hiddenZoneId = mapped
    }

    /**
     * @param value The billing method of the instance. Default value: `PostPaid`. Valid values: `PrePaid`, `PostPaid`. **NOTE:** It can be modified from `PostPaid` to `PrePaid` after version 1.63.0.
     */
    @JvmName("vnkysnaapljayfdj")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value An KMS encrypts password used to a instance. If the `account_password` is filled in, this field will be ignored.
     */
    @JvmName("cgtnsunjaaflrenj")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("tdvhkwtfptabdxia")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("kbmtsfwvqmcpqxwk")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time).
     */
    @JvmName("caielqnxorynxtbk")
    public suspend fun maintainEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainEndTime = mapped
    }

    /**
     * @param value The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time).
     */
    @JvmName("ipsdnmeruvlltpjp")
    public suspend fun maintainStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainStartTime = mapped
    }

    /**
     * @param value The name of DB instance. It must be 2 to 256 characters in length.
     */
    @JvmName("avqhquqdoafejpcg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The network type of the instance. Valid values:`Classic`, `VPC`.
     */
    @JvmName("lddrcleqailqfrxq")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The type of configuration changes performed. Default value: `DOWNGRADE`. Valid values:
     * - `UPGRADE`: The specifications are upgraded.
     * - `DOWNGRADE`: The specifications are downgraded.
     * **NOTE:** `order_type` is only applicable to instances when `instance_charge_type` is `PrePaid`.
     */
    @JvmName("ivmpcjaawmitivvi")
    public suspend fun orderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderType = mapped
    }

    /**
     * @param value Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
     */
    @JvmName("dqnfnkivquaphgfo")
    public suspend fun parameters(`value`: List<InstanceParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
     */
    @JvmName("apnydpkctuvfapax")
    public suspend fun parameters(argument: List<suspend InstanceParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
     */
    @JvmName("apsdekwljkbnggmd")
    public suspend fun parameters(vararg argument: suspend InstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
     */
    @JvmName("tueubhwuemhlqrni")
    public suspend fun parameters(argument: suspend InstanceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Set of parameters needs to be set after mongodb instance was launched. See `parameters` below.
     */
    @JvmName("ismgibsmefiuipui")
    public suspend fun parameters(vararg values: InstanceParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The duration that you will buy DB instance (in month). It is valid when `instance_charge_type` is `PrePaid`. Default value: `1`. Valid values: [1~9], 12, 24, 36.
     */
    @JvmName("locijcvqkuhrufqn")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The provisioned IOPS. Valid values: `0` to `50000`.
     */
    @JvmName("cytpfgngphvapioj")
    public suspend fun provisionedIops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedIops = mapped
    }

    /**
     * @param value The number of read-only nodes in the replica set instance. Default value: 0. Valid values: 0 to 5.
     */
    @JvmName("sobfypopengkepxj")
    public suspend fun readonlyReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readonlyReplicas = mapped
    }

    /**
     * @param value Number of replica set nodes. Valid values: `1`, `3`, `5`, `7`.
     */
    @JvmName("ykwxarqygelkiehm")
    public suspend fun replicationFactor(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationFactor = mapped
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("rqrkwuqrxbemtmch")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the specified Resource Access Management (RAM) role.
     */
    @JvmName("xuhnrybnexicemgs")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Configure the available area where the slave node (Secondary node) is located to realize multi-available area deployment. **NOTE:** This parameter value cannot be the same as `zone_id` and `hidden_zone_id` parameter values.
     */
    @JvmName("gbqqmbxvrhnrtaun")
    public suspend fun secondaryZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryZoneId = mapped
    }

    /**
     * @param value The Security Group ID of ECS.
     */
    @JvmName("gkxljyrjtirbaakq")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("wtsxbqposmhybuws")
    public suspend fun securityIpLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpLists = mapped
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("janomytithpnmkab")
    public suspend fun securityIpLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIpLists = mapped
    }

    /**
     * @param value The snapshot backup type. Default value: `Standard`. Valid values:
     * - `Standard`: standard backup.
     * - `Flash `: single-digit second backup.
     */
    @JvmName("vfjpyiwswwgjymgw")
    public suspend fun snapshotBackupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotBackupType = mapped
    }

    /**
     * @param value Actions performed on SSL functions. Valid values:
     * - `Open`: turn on SSL encryption.
     * - `Close`: turn off SSL encryption.
     * - `Update`: update SSL certificate.
     */
    @JvmName("jbfmybyoprtqqlxh")
    public suspend fun sslAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslAction = mapped
    }

    /**
     * @param value The storage engine of the instance. Default value: `WiredTiger`. Valid values: `WiredTiger`, `RocksDB`.
     */
    @JvmName("tuwpwgaophgdtucv")
    public suspend fun storageEngine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEngine = mapped
    }

    /**
     * @param value The storage type of the instance. Valid values: `cloud_essd1`, `cloud_essd2`, `cloud_essd3`, `cloud_auto`, `local_ssd`. **NOTE:** From version 1.229.0, `storage_type` can be modified. However, `storage_type` can only be modified to `cloud_auto`.
     */
    @JvmName("iwqbtrosmwbuktkd")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jgilmsenqwvuyioh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("nbmtbyxyrsmenmca")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The TDE(Transparent Data Encryption) status. Valid values: `enabled`.
     */
    @JvmName("mqwxfdnkcyvedlna")
    public suspend fun tdeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tdeStatus = mapped
    }

    /**
     * @param value The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
     */
    @JvmName("kxsookrmitqyxqfh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC.
     */
    @JvmName("gjdvouatwelskxhs")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the DB instance. it supports multiple zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in one of them.
     * The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `alicloud.getZones`.
     */
    @JvmName("bmsbefiaowfuyqka")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        accountPassword = accountPassword,
        autoRenew = autoRenew,
        backupInterval = backupInterval,
        backupPeriods = backupPeriods,
        backupRetentionPeriod = backupRetentionPeriod,
        backupTime = backupTime,
        cloudDiskEncryptionKey = cloudDiskEncryptionKey,
        dbInstanceClass = dbInstanceClass,
        dbInstanceStorage = dbInstanceStorage,
        effectiveTime = effectiveTime,
        encrypted = encrypted,
        encryptionKey = encryptionKey,
        encryptorName = encryptorName,
        engineVersion = engineVersion,
        hiddenZoneId = hiddenZoneId,
        instanceChargeType = instanceChargeType,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        maintainEndTime = maintainEndTime,
        maintainStartTime = maintainStartTime,
        name = name,
        networkType = networkType,
        orderType = orderType,
        parameters = parameters,
        period = period,
        provisionedIops = provisionedIops,
        readonlyReplicas = readonlyReplicas,
        replicationFactor = replicationFactor,
        resourceGroupId = resourceGroupId,
        roleArn = roleArn,
        secondaryZoneId = secondaryZoneId,
        securityGroupId = securityGroupId,
        securityIpLists = securityIpLists,
        snapshotBackupType = snapshotBackupType,
        sslAction = sslAction,
        storageEngine = storageEngine,
        storageType = storageType,
        tags = tags,
        tdeStatus = tdeStatus,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
