@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin

import com.pulumi.alicloud.mongodb.MongodbFunctions.getAccountsPlain
import com.pulumi.alicloud.mongodb.MongodbFunctions.getAuditPoliciesPlain
import com.pulumi.alicloud.mongodb.MongodbFunctions.getInstancesPlain
import com.pulumi.alicloud.mongodb.MongodbFunctions.getServerlessInstancesPlain
import com.pulumi.alicloud.mongodb.MongodbFunctions.getShardingNetworkPrivateAddressesPlain
import com.pulumi.alicloud.mongodb.MongodbFunctions.getShardingNetworkPublicAddressesPlain
import com.pulumi.alicloud.mongodb.MongodbFunctions.getZonesPlain
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetAccountsPlainArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetAccountsPlainArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetAuditPoliciesPlainArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetAuditPoliciesPlainArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetServerlessInstancesPlainArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetServerlessInstancesPlainArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetShardingNetworkPrivateAddressesPlainArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetShardingNetworkPrivateAddressesPlainArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetShardingNetworkPublicAddressesPlainArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetShardingNetworkPublicAddressesPlainArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetAccountsResult
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetAuditPoliciesResult
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetServerlessInstancesResult
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetShardingNetworkPrivateAddressesResult
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetShardingNetworkPublicAddressesResult
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetAccountsResult.Companion.toKotlin as getAccountsResultToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetAuditPoliciesResult.Companion.toKotlin as getAuditPoliciesResultToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetServerlessInstancesResult.Companion.toKotlin as getServerlessInstancesResultToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetShardingNetworkPrivateAddressesResult.Companion.toKotlin as getShardingNetworkPrivateAddressesResultToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetShardingNetworkPublicAddressesResult.Companion.toKotlin as getShardingNetworkPublicAddressesResultToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object MongodbFunctions {
    /**
     * This data source provides the Mongodb Accounts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.148.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.mongodb.getAccounts({
     *     instanceId: "example_value",
     *     accountName: "root",
     * });
     * export const mongodbAccountId1 = example.then(example => example.accounts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.mongodb.get_accounts(instance_id="example_value",
     *     account_name="root")
     * pulumi.export("mongodbAccountId1", example.accounts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.MongoDB.GetAccounts.Invoke(new()
     *     {
     *         InstanceId = "example_value",
     *         AccountName = "root",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mongodbAccountId1"] = example&#46;Apply(getAccountsResult => getAccountsResult&#46;Accounts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := mongodb.GetAccounts(ctx, &mongodb.GetAccountsArgs{
     * 			InstanceId:  "example_value",
     * 			AccountName: pulumi.StringRef("root"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mongodbAccountId1", example.Accounts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mongodb.MongodbFunctions;
     * import com.pulumi.alicloud.mongodb.inputs.GetAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MongodbFunctions.getAccounts(GetAccountsArgs.builder()
     *             .instanceId("example_value")
     *             .accountName("root")
     *             .build());
     *         ctx.export("mongodbAccountId1", example.applyValue(getAccountsResult -> getAccountsResult.accounts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:mongodb:getAccounts
     *       Arguments:
     *         instanceId: example_value
     *         accountName: root
     * outputs:
     *   mongodbAccountId1: ${example.accounts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccounts.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: GetAccountsPlainArgs): GetAccountsResult =
        getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())

    /**
     * @see [getAccounts].
     * @param accountName The name of the account. Valid values: `root`.
     * @param instanceId The ID of the instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(
        accountName: String? = null,
        instanceId: String,
        outputFile: String? = null,
    ): GetAccountsResult {
        val argument = GetAccountsPlainArgs(
            accountName = accountName,
            instanceId = instanceId,
            outputFile = outputFile,
        )
        return getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mongodb&#46;kotlin&#46;inputs&#46;GetAccountsPlainArgs].
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: suspend GetAccountsPlainArgsBuilder.() -> Unit): GetAccountsResult {
        val builder = GetAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountsResultToKotlin(getAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Mongodb Audit Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.148.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.mongodb.getAuditPolicies({
     *     dbInstanceId: "example_value",
     * });
     * export const mongodbAuditPolicyId1 = example.then(example => example.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.mongodb.get_audit_policies(db_instance_id="example_value")
     * pulumi.export("mongodbAuditPolicyId1", example.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.MongoDB.GetAuditPolicies.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mongodbAuditPolicyId1"] = example&#46;Apply(getAuditPoliciesResult => getAuditPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := mongodb.GetAuditPolicies(ctx, &mongodb.GetAuditPoliciesArgs{
     * 			DbInstanceId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mongodbAuditPolicyId1", example.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mongodb.MongodbFunctions;
     * import com.pulumi.alicloud.mongodb.inputs.GetAuditPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MongodbFunctions.getAuditPolicies(GetAuditPoliciesArgs.builder()
     *             .dbInstanceId("example_value")
     *             .build());
     *         ctx.export("mongodbAuditPolicyId1", example.applyValue(getAuditPoliciesResult -> getAuditPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:mongodb:getAuditPolicies
     *       Arguments:
     *         dbInstanceId: example_value
     * outputs:
     *   mongodbAuditPolicyId1: ${example.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAuditPolicies.
     * @return A collection of values returned by getAuditPolicies.
     */
    public suspend fun getAuditPolicies(argument: GetAuditPoliciesPlainArgs): GetAuditPoliciesResult =
        getAuditPoliciesResultToKotlin(getAuditPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getAuditPolicies].
     * @param dbInstanceId The id of the db instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAuditPolicies.
     */
    public suspend fun getAuditPolicies(dbInstanceId: String, outputFile: String? = null): GetAuditPoliciesResult {
        val argument = GetAuditPoliciesPlainArgs(
            dbInstanceId = dbInstanceId,
            outputFile = outputFile,
        )
        return getAuditPoliciesResultToKotlin(getAuditPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuditPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mongodb&#46;kotlin&#46;inputs&#46;GetAuditPoliciesPlainArgs].
     * @return A collection of values returned by getAuditPolicies.
     */
    public suspend fun getAuditPolicies(argument: suspend GetAuditPoliciesPlainArgsBuilder.() -> Unit): GetAuditPoliciesResult {
        val builder = GetAuditPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuditPoliciesResultToKotlin(getAuditPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.mongodb.getInstances` data source provides a collection of MongoDB instances available in Alicloud account.
     * Filters support regular expression for the instance name, engine or instance type.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const mongo = alicloud.mongodb.getInstances({
     *     nameRegex: "dds-.+\\d+",
     *     instanceType: "replicate",
     *     instanceClass: "dds.mongo.mid",
     *     availabilityZone: "eu-central-1a",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * mongo = alicloud.mongodb.get_instances(name_regex="dds-.+\\d+",
     *     instance_type="replicate",
     *     instance_class="dds.mongo.mid",
     *     availability_zone="eu-central-1a")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var mongo = AliCloud.MongoDB.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "dds-.+\\d+",
     *         InstanceType = "replicate",
     *         InstanceClass = "dds.mongo.mid",
     *         AvailabilityZone = "eu-central-1a",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := mongodb.GetInstances(ctx, &mongodb.GetInstancesArgs{
     * 			NameRegex:        pulumi.StringRef("dds-.+\\d+"),
     * 			InstanceType:     pulumi.StringRef("replicate"),
     * 			InstanceClass:    pulumi.StringRef("dds.mongo.mid"),
     * 			AvailabilityZone: pulumi.StringRef("eu-central-1a"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mongodb.MongodbFunctions;
     * import com.pulumi.alicloud.mongodb.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var mongo = MongodbFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("dds-.+\\d+")
     *             .instanceType("replicate")
     *             .instanceClass("dds.mongo.mid")
     *             .availabilityZone("eu-central-1a")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   mongo:
     *     fn::invoke:
     *       Function: alicloud:mongodb:getInstances
     *       Arguments:
     *         nameRegex: dds-.+\d+
     *         instanceType: replicate
     *         instanceClass: dds.mongo.mid
     *         availabilityZone: eu-central-1a
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param availabilityZone Instance availability zone.
     * @param ids The ids list of MongoDB instances
     * @param instanceClass Sizing of the instance to be queried.
     * @param instanceType Type of the instance to be queried. If it is set to `sharding`, the sharded cluster instances are listed. If it is set to `replicate`, replica set instances are listed. Default value `replicate`.
     * @param nameRegex A regex string to apply to the instance name.
     * @param outputFile The name of file that can save the collection of instances after running `pulumi preview`.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        availabilityZone: String? = null,
        ids: List<String>? = null,
        instanceClass: String? = null,
        instanceType: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            availabilityZone = availabilityZone,
            ids = ids,
            instanceClass = instanceClass,
            instanceType = instanceType,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mongodb&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Mongodb Serverless Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.148.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.mongodb.getServerlessInstances({
     *     ids: ["example_value"],
     *     dbInstanceClass: "example_value",
     *     dbInstanceDescription: "example_value",
     *     networkType: "VPC",
     *     resourceGroupId: "example_value",
     *     status: "Running",
     *     vpcId: "example_value",
     *     vswitchId: "example_value",
     *     zoneId: "example_value",
     *     tags: {
     *         Created: "MongodbServerlessInstance",
     *         For: "TF",
     *     },
     * });
     * export const mongodbServerlessInstanceId1 = example.then(example => example.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.mongodb.get_serverless_instances(ids=["example_value"],
     *     db_instance_class="example_value",
     *     db_instance_description="example_value",
     *     network_type="VPC",
     *     resource_group_id="example_value",
     *     status="Running",
     *     vpc_id="example_value",
     *     vswitch_id="example_value",
     *     zone_id="example_value",
     *     tags={
     *         "Created": "MongodbServerlessInstance",
     *         "For": "TF",
     *     })
     * pulumi.export("mongodbServerlessInstanceId1", example.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.MongoDB.GetServerlessInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         DbInstanceClass = "example_value",
     *         DbInstanceDescription = "example_value",
     *         NetworkType = "VPC",
     *         ResourceGroupId = "example_value",
     *         Status = "Running",
     *         VpcId = "example_value",
     *         VswitchId = "example_value",
     *         ZoneId = "example_value",
     *         Tags =
     *         {
     *             { "Created", "MongodbServerlessInstance" },
     *             { "For", "TF" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mongodbServerlessInstanceId1"] = example&#46;Apply(getServerlessInstancesResult => getServerlessInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := mongodb.GetServerlessInstances(ctx, &mongodb.GetServerlessInstancesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			DbInstanceClass:       pulumi.StringRef("example_value"),
     * 			DbInstanceDescription: pulumi.StringRef("example_value"),
     * 			NetworkType:           pulumi.StringRef("VPC"),
     * 			ResourceGroupId:       pulumi.StringRef("example_value"),
     * 			Status:                pulumi.StringRef("Running"),
     * 			VpcId:                 pulumi.StringRef("example_value"),
     * 			VswitchId:             pulumi.StringRef("example_value"),
     * 			ZoneId:                pulumi.StringRef("example_value"),
     * 			Tags: map[string]interface{}{
     * 				"Created": "MongodbServerlessInstance",
     * 				"For":     "TF",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mongodbServerlessInstanceId1", example.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mongodb.MongodbFunctions;
     * import com.pulumi.alicloud.mongodb.inputs.GetServerlessInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MongodbFunctions.getServerlessInstances(GetServerlessInstancesArgs.builder()
     *             .ids("example_value")
     *             .dbInstanceClass("example_value")
     *             .dbInstanceDescription("example_value")
     *             .networkType("VPC")
     *             .resourceGroupId("example_value")
     *             .status("Running")
     *             .vpcId("example_value")
     *             .vswitchId("example_value")
     *             .zoneId("example_value")
     *             .tags(Map.ofEntries(
     *                 Map.entry("Created", "MongodbServerlessInstance"),
     *                 Map.entry("For", "TF")
     *             ))
     *             .build());
     *         ctx.export("mongodbServerlessInstanceId1", example.applyValue(getServerlessInstancesResult -> getServerlessInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:mongodb:getServerlessInstances
     *       Arguments:
     *         ids:
     *           - example_value
     *         dbInstanceClass: example_value
     *         dbInstanceDescription: example_value
     *         networkType: VPC
     *         resourceGroupId: example_value
     *         status: Running
     *         vpcId: example_value
     *         vswitchId: example_value
     *         zoneId: example_value
     *         tags:
     *           Created: MongodbServerlessInstance
     *           For: TF
     * outputs:
     *   mongodbServerlessInstanceId1: ${example.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerlessInstances.
     * @return A collection of values returned by getServerlessInstances.
     */
    public suspend fun getServerlessInstances(argument: GetServerlessInstancesPlainArgs): GetServerlessInstancesResult =
        getServerlessInstancesResultToKotlin(getServerlessInstancesPlain(argument.toJava()).await())

    /**
     * @see [getServerlessInstances].
     * @param dbInstanceClass The db instance class.
     * @param dbInstanceDescription The db instance description.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Serverless Instance IDs.
     * @param networkType The network type of the instance. Valid values: `Classic` or `VPC`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param status The instance status. Valid values: `Creating`, `DBInstanceClassChanging`, `DBInstanceNetTypeChanging`, `Deleting`, `EngineVersionUpgrading`, `GuardSwitching`, `HASwitching`, `Importing`, `ImportingFromOthers`, `LinkSwitching`, `MinorVersionUpgrading`, `NodeCreating`, `NodeDeleting`, `Rebooting`, `Restoring`, `Running`, `SSLModifying`, `TDEModifying`, `TempDBInstanceCreating`, `Transing`, `TransingToOthers`, `released`.
     * @param tags A mapping of tags to assign to the resource.
     * @param vpcId The ID of the VPC network.
     * @param vswitchId The id of the vswitch.
     * @param zoneId The ID of the zone.
     * @return A collection of values returned by getServerlessInstances.
     */
    public suspend fun getServerlessInstances(
        dbInstanceClass: String? = null,
        dbInstanceDescription: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        networkType: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
        zoneId: String? = null,
    ): GetServerlessInstancesResult {
        val argument = GetServerlessInstancesPlainArgs(
            dbInstanceClass = dbInstanceClass,
            dbInstanceDescription = dbInstanceDescription,
            enableDetails = enableDetails,
            ids = ids,
            networkType = networkType,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
            vpcId = vpcId,
            vswitchId = vswitchId,
            zoneId = zoneId,
        )
        return getServerlessInstancesResultToKotlin(getServerlessInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mongodb&#46;kotlin&#46;inputs&#46;GetServerlessInstancesPlainArgs].
     * @return A collection of values returned by getServerlessInstances.
     */
    public suspend fun getServerlessInstances(argument: suspend GetServerlessInstancesPlainArgsBuilder.() -> Unit): GetServerlessInstancesResult {
        val builder = GetServerlessInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessInstancesResultToKotlin(getServerlessInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Mongodb Sharding Network Private Addresses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.157.0+.
     * @param argument A collection of arguments for invoking getShardingNetworkPrivateAddresses.
     * @return A collection of values returned by getShardingNetworkPrivateAddresses.
     */
    public suspend fun getShardingNetworkPrivateAddresses(argument: GetShardingNetworkPrivateAddressesPlainArgs): GetShardingNetworkPrivateAddressesResult =
        getShardingNetworkPrivateAddressesResultToKotlin(getShardingNetworkPrivateAddressesPlain(argument.toJava()).await())

    /**
     * @see [getShardingNetworkPrivateAddresses].
     * @param dbInstanceId The db instance id.
     * @param nodeId The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param role The role of the node. Valid values: `Primary` or `Secondary`.
     * @return A collection of values returned by getShardingNetworkPrivateAddresses.
     */
    public suspend fun getShardingNetworkPrivateAddresses(
        dbInstanceId: String,
        nodeId: String? = null,
        outputFile: String? = null,
        role: String? = null,
    ): GetShardingNetworkPrivateAddressesResult {
        val argument = GetShardingNetworkPrivateAddressesPlainArgs(
            dbInstanceId = dbInstanceId,
            nodeId = nodeId,
            outputFile = outputFile,
            role = role,
        )
        return getShardingNetworkPrivateAddressesResultToKotlin(getShardingNetworkPrivateAddressesPlain(argument.toJava()).await())
    }

    /**
     * @see [getShardingNetworkPrivateAddresses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mongodb&#46;kotlin&#46;inputs&#46;GetShardingNetworkPrivateAddressesPlainArgs].
     * @return A collection of values returned by getShardingNetworkPrivateAddresses.
     */
    public suspend fun getShardingNetworkPrivateAddresses(argument: suspend GetShardingNetworkPrivateAddressesPlainArgsBuilder.() -> Unit): GetShardingNetworkPrivateAddressesResult {
        val builder = GetShardingNetworkPrivateAddressesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getShardingNetworkPrivateAddressesResultToKotlin(getShardingNetworkPrivateAddressesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Mongodb Sharding Network Public Addresses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.149.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.mongodb.getShardingNetworkPublicAddresses({
     *     dbInstanceId: "example_value",
     *     nodeId: "example_value",
     *     role: "Primary",
     * });
     * export const mongodbShardingNetworkPublicAddressDbInstanceId1 = example.then(example => example.addresses?.[0]?.dbInstanceId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.mongodb.get_sharding_network_public_addresses(db_instance_id="example_value",
     *     node_id="example_value",
     *     role="Primary")
     * pulumi.export("mongodbShardingNetworkPublicAddressDbInstanceId1", example.addresses[0].db_instance_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.MongoDB.GetShardingNetworkPublicAddresses.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *         NodeId = "example_value",
     *         Role = "Primary",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["mongodbShardingNetworkPublicAddressDbInstanceId1"] = example&#46;Apply(getShardingNetworkPublicAddressesResult => getShardingNetworkPublicAddressesResult&#46;Addresses[0]?.DbInstanceId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := mongodb.GetShardingNetworkPublicAddresses(ctx, &mongodb.GetShardingNetworkPublicAddressesArgs{
     * 			DbInstanceId: "example_value",
     * 			NodeId:       pulumi.StringRef("example_value"),
     * 			Role:         pulumi.StringRef("Primary"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("mongodbShardingNetworkPublicAddressDbInstanceId1", example.Addresses[0].DbInstanceId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mongodb.MongodbFunctions;
     * import com.pulumi.alicloud.mongodb.inputs.GetShardingNetworkPublicAddressesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = MongodbFunctions.getShardingNetworkPublicAddresses(GetShardingNetworkPublicAddressesArgs.builder()
     *             .dbInstanceId("example_value")
     *             .nodeId("example_value")
     *             .role("Primary")
     *             .build());
     *         ctx.export("mongodbShardingNetworkPublicAddressDbInstanceId1", example.applyValue(getShardingNetworkPublicAddressesResult -> getShardingNetworkPublicAddressesResult.addresses()[0].dbInstanceId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:mongodb:getShardingNetworkPublicAddresses
     *       Arguments:
     *         dbInstanceId: example_value
     *         nodeId: example_value
     *         role: Primary
     * outputs:
     *   mongodbShardingNetworkPublicAddressDbInstanceId1: ${example.addresses[0].dbInstanceId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getShardingNetworkPublicAddresses.
     * @return A collection of values returned by getShardingNetworkPublicAddresses.
     */
    public suspend fun getShardingNetworkPublicAddresses(argument: GetShardingNetworkPublicAddressesPlainArgs): GetShardingNetworkPublicAddressesResult =
        getShardingNetworkPublicAddressesResultToKotlin(getShardingNetworkPublicAddressesPlain(argument.toJava()).await())

    /**
     * @see [getShardingNetworkPublicAddresses].
     * @param dbInstanceId The db instance id.
     * @param nodeId The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param role The role of the node. Valid values: `Primary` or `Secondary`.
     * @return A collection of values returned by getShardingNetworkPublicAddresses.
     */
    public suspend fun getShardingNetworkPublicAddresses(
        dbInstanceId: String,
        nodeId: String? = null,
        outputFile: String? = null,
        role: String? = null,
    ): GetShardingNetworkPublicAddressesResult {
        val argument = GetShardingNetworkPublicAddressesPlainArgs(
            dbInstanceId = dbInstanceId,
            nodeId = nodeId,
            outputFile = outputFile,
            role = role,
        )
        return getShardingNetworkPublicAddressesResultToKotlin(getShardingNetworkPublicAddressesPlain(argument.toJava()).await())
    }

    /**
     * @see [getShardingNetworkPublicAddresses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mongodb&#46;kotlin&#46;inputs&#46;GetShardingNetworkPublicAddressesPlainArgs].
     * @return A collection of values returned by getShardingNetworkPublicAddresses.
     */
    public suspend fun getShardingNetworkPublicAddresses(argument: suspend GetShardingNetworkPublicAddressesPlainArgsBuilder.() -> Unit): GetShardingNetworkPublicAddressesResult {
        val builder = GetShardingNetworkPublicAddressesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getShardingNetworkPublicAddressesResultToKotlin(getShardingNetworkPublicAddressesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for mongoDB that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.73.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const zonesIds = alicloud.mongodb.getZones({});
     * // Create an mongoDB instance with the first matched zone
     * const mongodb = new alicloud.mongodb.Instance("mongodb", {zoneId: zonesIds.then(zonesIds => zonesIds.zones?.[0]?.id)});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * zones_ids = alicloud.mongodb.get_zones()
     * # Create an mongoDB instance with the first matched zone
     * mongodb = alicloud.mongodb.Instance("mongodb", zone_id=zones_ids.zones[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var zonesIds = AliCloud.MongoDB.GetZones.Invoke();
     *     // Create an mongoDB instance with the first matched zone
     *     var mongodb = new AliCloud.MongoDB.Instance("mongodb", new()
     *     {
     *         ZoneId = zonesIds.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		zonesIds, err := mongodb.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Create an mongoDB instance with the first matched zone
     * 		_, err = mongodb.NewInstance(ctx, "mongodb", &mongodb.InstanceArgs{
     * 			ZoneId: pulumi.String(zonesIds.Zones[0].Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.mongodb.MongodbFunctions;
     * import com.pulumi.alicloud.mongodb.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.mongodb.Instance;
     * import com.pulumi.alicloud.mongodb.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var zonesIds = MongodbFunctions.getZones();
     *         // Create an mongoDB instance with the first matched zone
     *         var mongodb = new Instance("mongodb", InstanceArgs.builder()
     *             .zoneId(zonesIds.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # Create an mongoDB instance with the first matched zone
     *   mongodb:
     *     type: alicloud:mongodb:Instance
     *     properties:
     *       zoneId: ${zonesIds.zones[0].id}
     * variables:
     *   # Declare the data source
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:mongodb:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch MongoDB instances.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(multi: Boolean? = null, outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            multi = multi,
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;mongodb&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
