@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin

import com.pulumi.alicloud.mongodb.ServerlessInstanceArgs.builder
import com.pulumi.alicloud.mongodb.kotlin.inputs.ServerlessInstanceSecurityIpGroupArgs
import com.pulumi.alicloud.mongodb.kotlin.inputs.ServerlessInstanceSecurityIpGroupArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MongoDB Serverless Instance resource.
 * For information about MongoDB Serverless Instance and how to use it, see [What is Serverless Instance](https://www.alibabacloud.com/help/doc-detail/26558.html).
 * > **NOTE:** Deprecated since v1.214.0.
 * > **DEPRECATED:**  This resource has been deprecated from version `1.214.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.mongodb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "default-NODELETING",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[0]?.id,
 * }));
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
 * const example = new alicloud.mongodb.ServerlessInstance("example", {
 *     accountPassword: "Abc12345",
 *     dbInstanceDescription: "example_value",
 *     dbInstanceStorage: 5,
 *     storageEngine: "WiredTiger",
 *     capacityUnit: 100,
 *     engine: "MongoDB",
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.groups?.[0]?.id),
 *     engineVersion: "4.2",
 *     period: 1,
 *     periodPriceType: "Month",
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     tags: {
 *         Created: "MongodbServerlessInstance",
 *         For: "TF",
 *     },
 *     securityIpGroups: [{
 *         securityIpGroupAttribute: "example_value",
 *         securityIpGroupName: "example_value",
 *         securityIpList: "192.168.0.1",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.mongodb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[0].id)
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
 * example = alicloud.mongodb.ServerlessInstance("example",
 *     account_password="Abc12345",
 *     db_instance_description="example_value",
 *     db_instance_storage=5,
 *     storage_engine="WiredTiger",
 *     capacity_unit=100,
 *     engine="MongoDB",
 *     resource_group_id=default_get_resource_groups.groups[0].id,
 *     engine_version="4.2",
 *     period=1,
 *     period_price_type="Month",
 *     vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[0].id,
 *     vswitch_id=default_get_switches.ids[0],
 *     tags={
 *         "Created": "MongodbServerlessInstance",
 *         "For": "TF",
 *     },
 *     security_ip_groups=[{
 *         "security_ip_group_attribute": "example_value",
 *         "security_ip_group_name": "example_value",
 *         "security_ip_list": "192.168.0.1",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.MongoDB.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "default-NODELETING",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var example = new AliCloud.MongoDB.ServerlessInstance("example", new()
 *     {
 *         AccountPassword = "Abc12345",
 *         DbInstanceDescription = "example_value",
 *         DbInstanceStorage = 5,
 *         StorageEngine = "WiredTiger",
 *         CapacityUnit = 100,
 *         Engine = "MongoDB",
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *         EngineVersion = "4.2",
 *         Period = 1,
 *         PeriodPriceType = "Month",
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         Tags =
 *         {
 *             { "Created", "MongodbServerlessInstance" },
 *             { "For", "TF" },
 *         },
 *         SecurityIpGroups = new[]
 *         {
 *             new AliCloud.MongoDB.Inputs.ServerlessInstanceSecurityIpGroupArgs
 *             {
 *                 SecurityIpGroupAttribute = "example_value",
 *                 SecurityIpGroupName = "example_value",
 *                 SecurityIpList = "192.168.0.1",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := mongodb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("default-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mongodb.NewServerlessInstance(ctx, "example", &mongodb.ServerlessInstanceArgs{
 * 			AccountPassword:       pulumi.String("Abc12345"),
 * 			DbInstanceDescription: pulumi.String("example_value"),
 * 			DbInstanceStorage:     pulumi.Int(5),
 * 			StorageEngine:         pulumi.String("WiredTiger"),
 * 			CapacityUnit:          pulumi.Int(100),
 * 			Engine:                pulumi.String("MongoDB"),
 * 			ResourceGroupId:       pulumi.String(defaultGetResourceGroups.Groups[0].Id),
 * 			EngineVersion:         pulumi.String("4.2"),
 * 			Period:                pulumi.Int(1),
 * 			PeriodPriceType:       pulumi.String("Month"),
 * 			VpcId:                 pulumi.String(defaultGetNetworks.Ids[0]),
 * 			ZoneId:                pulumi.String(_default.Zones[0].Id),
 * 			VswitchId:             pulumi.String(defaultGetSwitches.Ids[0]),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("MongodbServerlessInstance"),
 * 				"For":     pulumi.String("TF"),
 * 			},
 * 			SecurityIpGroups: mongodb.ServerlessInstanceSecurityIpGroupArray{
 * 				&mongodb.ServerlessInstanceSecurityIpGroupArgs{
 * 					SecurityIpGroupAttribute: pulumi.String("example_value"),
 * 					SecurityIpGroupName:      pulumi.String("example_value"),
 * 					SecurityIpList:           pulumi.String("192.168.0.1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mongodb.MongodbFunctions;
 * import com.pulumi.alicloud.mongodb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.mongodb.ServerlessInstance;
 * import com.pulumi.alicloud.mongodb.ServerlessInstanceArgs;
 * import com.pulumi.alicloud.mongodb.inputs.ServerlessInstanceSecurityIpGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = MongodbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("default-NODELETING")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
 *         var example = new ServerlessInstance("example", ServerlessInstanceArgs.builder()
 *             .accountPassword("Abc12345")
 *             .dbInstanceDescription("example_value")
 *             .dbInstanceStorage(5)
 *             .storageEngine("WiredTiger")
 *             .capacityUnit(100)
 *             .engine("MongoDB")
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .engineVersion("4.2")
 *             .period(1)
 *             .periodPriceType("Month")
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "MongodbServerlessInstance"),
 *                 Map.entry("For", "TF")
 *             ))
 *             .securityIpGroups(ServerlessInstanceSecurityIpGroupArgs.builder()
 *                 .securityIpGroupAttribute("example_value")
 *                 .securityIpGroupName("example_value")
 *                 .securityIpList("192.168.0.1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:mongodb:ServerlessInstance
 *     properties:
 *       accountPassword: Abc12345
 *       dbInstanceDescription: example_value
 *       dbInstanceStorage: 5
 *       storageEngine: WiredTiger
 *       capacityUnit: 100
 *       engine: MongoDB
 *       resourceGroupId: ${defaultGetResourceGroups.groups[0].id}
 *       engineVersion: '4.2'
 *       period: 1
 *       periodPriceType: Month
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       zoneId: ${default.zones[0].id}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       tags:
 *         Created: MongodbServerlessInstance
 *         For: TF
 *       securityIpGroups:
 *         - securityIpGroupAttribute: example_value
 *           securityIpGroupName: example_value
 *           securityIpList: 192.168.0.1
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:mongodb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: default-NODELETING
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[0].id}
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * MongoDB Serverless Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mongodb/serverlessInstance:ServerlessInstance example <id>
 * ```
 * @property accountPassword The password of the database logon account.
 * * The password length is `8` to `32` bits.
 * * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
 * @property autoRenew Set whether the instance is automatically renewed.
 * @property capacityUnit The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
 * @property dbInstanceDescription The db instance description.
 * @property dbInstanceStorage The db instance storage. Valid values: `1` to `100`.
 * @property engine The database engine of the instance. Valid values: `MongoDB`.
 * @property engineVersion The database version number. Valid values: `4.2`.
 * @property maintainEndTime The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
 * @property maintainStartTime The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
 * @property period The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
 * @property periodPriceType The period price type. Valid values: `Day`, `Month`.
 * @property resourceGroupId The ID of the resource group.
 * @property securityIpGroups An array that consists of the information of IP whitelists.
 * @property storageEngine The storage engine used by the instance. Valid values: `WiredTiger`.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The ID of the VPC network.
 * @property vswitchId The of the vswitch.
 * @property zoneId The ID of the zone. Use this parameter to specify the zone created by the instance.
 */
public data class ServerlessInstanceArgs(
    public val accountPassword: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val capacityUnit: Output<Int>? = null,
    public val dbInstanceDescription: Output<String>? = null,
    public val dbInstanceStorage: Output<Int>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val maintainEndTime: Output<String>? = null,
    public val maintainStartTime: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodPriceType: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityIpGroups: Output<List<ServerlessInstanceSecurityIpGroupArgs>>? = null,
    public val storageEngine: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.mongodb.ServerlessInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.mongodb.ServerlessInstanceArgs =
        com.pulumi.alicloud.mongodb.ServerlessInstanceArgs.builder()
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .capacityUnit(capacityUnit?.applyValue({ args0 -> args0 }))
            .dbInstanceDescription(dbInstanceDescription?.applyValue({ args0 -> args0 }))
            .dbInstanceStorage(dbInstanceStorage?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .maintainEndTime(maintainEndTime?.applyValue({ args0 -> args0 }))
            .maintainStartTime(maintainStartTime?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodPriceType(periodPriceType?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityIpGroups(
                securityIpGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageEngine(storageEngine?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessInstanceArgs].
 */
@PulumiTagMarker
public class ServerlessInstanceArgsBuilder internal constructor() {
    private var accountPassword: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var capacityUnit: Output<Int>? = null

    private var dbInstanceDescription: Output<String>? = null

    private var dbInstanceStorage: Output<Int>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var maintainEndTime: Output<String>? = null

    private var maintainStartTime: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodPriceType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityIpGroups: Output<List<ServerlessInstanceSecurityIpGroupArgs>>? = null

    private var storageEngine: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The password of the database logon account.
     * * The password length is `8` to `32` bits.
     * * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
     */
    @JvmName("mlaaawgibpriedkx")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value Set whether the instance is automatically renewed.
     */
    @JvmName("dffevspcvlivyiwh")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
     */
    @JvmName("wrbspsaftlxpdhej")
    public suspend fun capacityUnit(`value`: Output<Int>) {
        this.capacityUnit = value
    }

    /**
     * @param value The db instance description.
     */
    @JvmName("pblrckjrgpkvdhyb")
    public suspend fun dbInstanceDescription(`value`: Output<String>) {
        this.dbInstanceDescription = value
    }

    /**
     * @param value The db instance storage. Valid values: `1` to `100`.
     */
    @JvmName("hipqqqdyigfkvpbc")
    public suspend fun dbInstanceStorage(`value`: Output<Int>) {
        this.dbInstanceStorage = value
    }

    /**
     * @param value The database engine of the instance. Valid values: `MongoDB`.
     */
    @JvmName("cfqenieceyuvrnlp")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The database version number. Valid values: `4.2`.
     */
    @JvmName("efojwsxqshqnkvpp")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
     */
    @JvmName("hosewcheqqxqusah")
    public suspend fun maintainEndTime(`value`: Output<String>) {
        this.maintainEndTime = value
    }

    /**
     * @param value The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
     */
    @JvmName("beradrsrrdcmxvog")
    public suspend fun maintainStartTime(`value`: Output<String>) {
        this.maintainStartTime = value
    }

    /**
     * @param value The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
     */
    @JvmName("sjclaetkgjnsivvw")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The period price type. Valid values: `Day`, `Month`.
     */
    @JvmName("dpjdhuqndotvwvmo")
    public suspend fun periodPriceType(`value`: Output<String>) {
        this.periodPriceType = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("uogfxmflhuekerfi")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value An array that consists of the information of IP whitelists.
     */
    @JvmName("kkcyyhoqgmpmudti")
    public suspend fun securityIpGroups(`value`: Output<List<ServerlessInstanceSecurityIpGroupArgs>>) {
        this.securityIpGroups = value
    }

    @JvmName("xjgopmrokvmpvqiw")
    public suspend fun securityIpGroups(vararg values: Output<ServerlessInstanceSecurityIpGroupArgs>) {
        this.securityIpGroups = Output.all(values.asList())
    }

    /**
     * @param values An array that consists of the information of IP whitelists.
     */
    @JvmName("kyrkbksoifvijwmv")
    public suspend fun securityIpGroups(values: List<Output<ServerlessInstanceSecurityIpGroupArgs>>) {
        this.securityIpGroups = Output.all(values)
    }

    /**
     * @param value The storage engine used by the instance. Valid values: `WiredTiger`.
     */
    @JvmName("rrlcxkyochicnrab")
    public suspend fun storageEngine(`value`: Output<String>) {
        this.storageEngine = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("cvpgxvygccrnxnxs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC network.
     */
    @JvmName("dyfgbjoqghocsdld")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The of the vswitch.
     */
    @JvmName("nssqndsvcrrwrmpi")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The ID of the zone. Use this parameter to specify the zone created by the instance.
     */
    @JvmName("gltqeqgmehafmhgo")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The password of the database logon account.
     * * The password length is `8` to `32` bits.
     * * The password consists of at least any three of uppercase letters, lowercase letters, numbers, and special characters. The special character is `!#$%^&*()_+-=`. The MongoDB Serverless instance provides a default database login account. This account cannot be modified. You can only set or modify the password for this account.
     */
    @JvmName("wjsknpqvjfcaaqno")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value Set whether the instance is automatically renewed.
     */
    @JvmName("snckvmjdssdwcutx")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The I/O throughput consumed by the instance. Valid values: `100` to `8000`.
     */
    @JvmName("ynscxclnhcveyahu")
    public suspend fun capacityUnit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityUnit = mapped
    }

    /**
     * @param value The db instance description.
     */
    @JvmName("hdjetxescmuxevdg")
    public suspend fun dbInstanceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceDescription = mapped
    }

    /**
     * @param value The db instance storage. Valid values: `1` to `100`.
     */
    @JvmName("fbwoesusgplvjttx")
    public suspend fun dbInstanceStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceStorage = mapped
    }

    /**
     * @param value The database engine of the instance. Valid values: `MongoDB`.
     */
    @JvmName("mjbqhchegjexjhrm")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The database version number. Valid values: `4.2`.
     */
    @JvmName("botfqoxcjwoxnxio")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The end time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC. **NOTE:** The difference between the start time and end time must be one hour. For example, if `maintain_start_time` is `01:00Z`, `maintain_end_time` must be `02:00Z`.
     */
    @JvmName("livmkuqlnwcunfhs")
    public suspend fun maintainEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainEndTime = mapped
    }

    /**
     * @param value The start time of the maintenance window. Specify the time in the `HH:mmZ` format. The time must be in UTC.
     */
    @JvmName("wkeqqubptislwqfl")
    public suspend fun maintainStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainStartTime = mapped
    }

    /**
     * @param value The purchase duration of the instance, in months. Valid values: `1` to `9`, `12`, `24`, `36`, `60`.
     */
    @JvmName("nrdbgnpdemmjfwsg")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The period price type. Valid values: `Day`, `Month`.
     */
    @JvmName("vsdwyprhbgujjyaf")
    public suspend fun periodPriceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodPriceType = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("fovvjdjdtvcckcrg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value An array that consists of the information of IP whitelists.
     */
    @JvmName("kjncyctbhrnkyaum")
    public suspend fun securityIpGroups(`value`: List<ServerlessInstanceSecurityIpGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpGroups = mapped
    }

    /**
     * @param argument An array that consists of the information of IP whitelists.
     */
    @JvmName("xnvpbkovdprovyrn")
    public suspend fun securityIpGroups(argument: List<suspend ServerlessInstanceSecurityIpGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServerlessInstanceSecurityIpGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityIpGroups = mapped
    }

    /**
     * @param argument An array that consists of the information of IP whitelists.
     */
    @JvmName("wjtpgntcmngfbpxs")
    public suspend fun securityIpGroups(vararg argument: suspend ServerlessInstanceSecurityIpGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServerlessInstanceSecurityIpGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityIpGroups = mapped
    }

    /**
     * @param argument An array that consists of the information of IP whitelists.
     */
    @JvmName("ereeetdcbsuwbkqd")
    public suspend fun securityIpGroups(argument: suspend ServerlessInstanceSecurityIpGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServerlessInstanceSecurityIpGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.securityIpGroups = mapped
    }

    /**
     * @param values An array that consists of the information of IP whitelists.
     */
    @JvmName("klwmnygnkdulkrvm")
    public suspend fun securityIpGroups(vararg values: ServerlessInstanceSecurityIpGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIpGroups = mapped
    }

    /**
     * @param value The storage engine used by the instance. Valid values: `WiredTiger`.
     */
    @JvmName("gngvntwfhqxbpmiy")
    public suspend fun storageEngine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEngine = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("pyunpwafpblfblpx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("alogxoxaxsykupby")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC network.
     */
    @JvmName("rykyhkkojovnhher")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The of the vswitch.
     */
    @JvmName("hmphhhbpnycjpbgl")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The ID of the zone. Use this parameter to specify the zone created by the instance.
     */
    @JvmName("yexkwjlplacorvcp")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ServerlessInstanceArgs = ServerlessInstanceArgs(
        accountPassword = accountPassword,
        autoRenew = autoRenew,
        capacityUnit = capacityUnit,
        dbInstanceDescription = dbInstanceDescription,
        dbInstanceStorage = dbInstanceStorage,
        engine = engine,
        engineVersion = engineVersion,
        maintainEndTime = maintainEndTime,
        maintainStartTime = maintainStartTime,
        period = period,
        periodPriceType = periodPriceType,
        resourceGroupId = resourceGroupId,
        securityIpGroups = securityIpGroups,
        storageEngine = storageEngine,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
