@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.mongodb.kotlin

import com.pulumi.alicloud.mongodb.kotlin.outputs.ShardingInstanceConfigServerList
import com.pulumi.alicloud.mongodb.kotlin.outputs.ShardingInstanceMongoList
import com.pulumi.alicloud.mongodb.kotlin.outputs.ShardingInstanceShardList
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.mongodb.kotlin.outputs.ShardingInstanceConfigServerList.Companion.toKotlin as shardingInstanceConfigServerListToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.ShardingInstanceMongoList.Companion.toKotlin as shardingInstanceMongoListToKotlin
import com.pulumi.alicloud.mongodb.kotlin.outputs.ShardingInstanceShardList.Companion.toKotlin as shardingInstanceShardListToKotlin

/**
 * Builder for [ShardingInstance].
 */
@PulumiTagMarker
public class ShardingInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ShardingInstanceArgs = ShardingInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ShardingInstanceArgsBuilder.() -> Unit) {
        val builder = ShardingInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ShardingInstance {
        val builtJavaResource = com.pulumi.alicloud.mongodb.ShardingInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ShardingInstance(builtJavaResource)
    }
}

/**
 * Provides a MongoDB Sharding Instance resource supports replica set instances only. the MongoDB provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/doc-detail/26558.htm)
 * > **NOTE:** Available since v1.40.0.
 * > **NOTE:**  The following regions don't support create Classic network MongoDB Sharding Instance.
 * [`cn-zhangjiakou`,`cn-huhehaote`,`ap-southeast-3`,`ap-southeast-5`,`me-east-1`,`ap-northeast-1`,`eu-west-1`]
 * > **NOTE:**  Create MongoDB Sharding instance or change instance type and storage would cost 10~20 minutes. Please make full preparation.
 * ## Example Usage
 * ### Create a Mongodb Sharding instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.mongodb.getZones({});
 * const index = _default.then(_default => _default.zones).length.then(length => length - 1);
 * const zoneId = _default.then(_default => _default.zones[index].id);
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: zoneId,
 * });
 * const defaultShardingInstance = new alicloud.mongodb.ShardingInstance("default", {
 *     engineVersion: "4.2",
 *     vswitchId: defaultSwitch.id,
 *     zoneId: zoneId,
 *     name: name,
 *     mongoLists: [
 *         {
 *             nodeClass: "dds.mongos.mid",
 *         },
 *         {
 *             nodeClass: "dds.mongos.mid",
 *         },
 *     ],
 *     shardLists: [
 *         {
 *             nodeClass: "dds.shard.mid",
 *             nodeStorage: 10,
 *         },
 *         {
 *             nodeClass: "dds.shard.standard",
 *             nodeStorage: 20,
 *             readonlyReplicas: 1,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.mongodb.get_zones()
 * index = len(default.zones) - 1
 * zone_id = default.zones[index].id
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.17.3.0/24")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=zone_id)
 * default_sharding_instance = alicloud.mongodb.ShardingInstance("default",
 *     engine_version="4.2",
 *     vswitch_id=default_switch.id,
 *     zone_id=zone_id,
 *     name=name,
 *     mongo_lists=[
 *         {
 *             "node_class": "dds.mongos.mid",
 *         },
 *         {
 *             "node_class": "dds.mongos.mid",
 *         },
 *     ],
 *     shard_lists=[
 *         {
 *             "node_class": "dds.shard.mid",
 *             "node_storage": 10,
 *         },
 *         {
 *             "node_class": "dds.shard.standard",
 *             "node_storage": 20,
 *             "readonly_replicas": 1,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.MongoDB.GetZones.Invoke();
 *     var index = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)).Length.Apply(length => length - 1);
 *     var zoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones)[index].Id);
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = zoneId,
 *     });
 *     var defaultShardingInstance = new AliCloud.MongoDB.ShardingInstance("default", new()
 *     {
 *         EngineVersion = "4.2",
 *         VswitchId = defaultSwitch.Id,
 *         ZoneId = zoneId,
 *         Name = name,
 *         MongoLists = new[]
 *         {
 *             new AliCloud.MongoDB.Inputs.ShardingInstanceMongoListArgs
 *             {
 *                 NodeClass = "dds.mongos.mid",
 *             },
 *             new AliCloud.MongoDB.Inputs.ShardingInstanceMongoListArgs
 *             {
 *                 NodeClass = "dds.mongos.mid",
 *             },
 *         },
 *         ShardLists = new[]
 *         {
 *             new AliCloud.MongoDB.Inputs.ShardingInstanceShardListArgs
 *             {
 *                 NodeClass = "dds.shard.mid",
 *                 NodeStorage = 10,
 *             },
 *             new AliCloud.MongoDB.Inputs.ShardingInstanceShardListArgs
 *             {
 *                 NodeClass = "dds.shard.standard",
 *                 NodeStorage = 20,
 *                 ReadonlyReplicas = 1,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/mongodb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := mongodb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		index := pulumi.Float64(len(_default.Zones)) - 1
 * 		zoneId := _default.Zones[index].Id
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = mongodb.NewShardingInstance(ctx, "default", &mongodb.ShardingInstanceArgs{
 * 			EngineVersion: pulumi.String("4.2"),
 * 			VswitchId:     defaultSwitch.ID(),
 * 			ZoneId:        pulumi.String(zoneId),
 * 			Name:          pulumi.String(name),
 * 			MongoLists: mongodb.ShardingInstanceMongoListArray{
 * 				&mongodb.ShardingInstanceMongoListArgs{
 * 					NodeClass: pulumi.String("dds.mongos.mid"),
 * 				},
 * 				&mongodb.ShardingInstanceMongoListArgs{
 * 					NodeClass: pulumi.String("dds.mongos.mid"),
 * 				},
 * 			},
 * 			ShardLists: mongodb.ShardingInstanceShardListArray{
 * 				&mongodb.ShardingInstanceShardListArgs{
 * 					NodeClass:   pulumi.String("dds.shard.mid"),
 * 					NodeStorage: pulumi.Int(10),
 * 				},
 * 				&mongodb.ShardingInstanceShardListArgs{
 * 					NodeClass:        pulumi.String("dds.shard.standard"),
 * 					NodeStorage:      pulumi.Int(20),
 * 					ReadonlyReplicas: pulumi.Int(1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.mongodb.MongodbFunctions;
 * import com.pulumi.alicloud.mongodb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.mongodb.ShardingInstance;
 * import com.pulumi.alicloud.mongodb.ShardingInstanceArgs;
 * import com.pulumi.alicloud.mongodb.inputs.ShardingInstanceMongoListArgs;
 * import com.pulumi.alicloud.mongodb.inputs.ShardingInstanceShardListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = MongodbFunctions.getZones();
 *         final var index = default_.zones().length() - 1;
 *         final var zoneId = default_.zones()[index].id();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(zoneId)
 *             .build());
 *         var defaultShardingInstance = new ShardingInstance("defaultShardingInstance", ShardingInstanceArgs.builder()
 *             .engineVersion("4.2")
 *             .vswitchId(defaultSwitch.id())
 *             .zoneId(zoneId)
 *             .name(name)
 *             .mongoLists(
 *                 ShardingInstanceMongoListArgs.builder()
 *                     .nodeClass("dds.mongos.mid")
 *                     .build(),
 *                 ShardingInstanceMongoListArgs.builder()
 *                     .nodeClass("dds.mongos.mid")
 *                     .build())
 *             .shardLists(
 *                 ShardingInstanceShardListArgs.builder()
 *                     .nodeClass("dds.shard.mid")
 *                     .nodeStorage("10")
 *                     .build(),
 *                 ShardingInstanceShardListArgs.builder()
 *                     .nodeClass("dds.shard.standard")
 *                     .nodeStorage("20")
 *                     .readonlyReplicas("1")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing mongodb-sharding module
 * to create a MongoDB Sharding Instance resource one-click.
 * ## Import
 * MongoDB Sharding Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:mongodb/shardingInstance:ShardingInstance example dds-bp1291daeda44195
 * ```
 */
public class ShardingInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.mongodb.ShardingInstance,
) : KotlinCustomResource(javaResource, ShardingInstanceMapper) {
    /**
     * Password of the root account. It is a string of 6 to 32 characters and is composed of letters, numbers, and underlines.
     */
    public val accountPassword: Output<String>?
        get() = javaResource.accountPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Auto renew for prepaid. Default value: `false`. Valid values: `true`, `false`.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * MongoDB Instance backup period. It is required when `backup_time` was existed. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]&#46; Default to [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday]
     */
    public val backupPeriods: Output<List<String>>
        get() = javaResource.backupPeriods().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Sharding Instance backup time. It is required when `backup_period` was existed. In the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. If not set, the system will return a default, like "23:00Z-24:00Z".
     */
    public val backupTime: Output<String>
        get() = javaResource.backupTime().applyValue({ args0 -> args0 })

    /**
     * The ConfigServer nodes of the instance. See `config_server_list` below.
     */
    public val configServerLists: Output<List<ShardingInstanceConfigServerList>>
        get() = javaResource.configServerLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> shardingInstanceConfigServerListToKotlin(args0) })
            })
        })

    /**
     * Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/en/doc-detail/61884.htm) `EngineVersion`. **NOTE:** From version 1.225.1, `engine_version` can be modified.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The billing method of the instance. Default value: `PostPaid`. Valid values: `PrePaid`, `PostPaid`. **NOTE:** It can be modified from `PostPaid` to `PrePaid` after version v1.141.0.
     */
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * An KMS encrypts password used to a instance. If the `account_password` is filled in, this field will be ignored.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The Mongo nodes of the instance. The mongo-node count can be purchased is in range of [2, 32]. See `mongo_list` below.
     */
    public val mongoLists: Output<List<ShardingInstanceMongoList>>
        get() = javaResource.mongoLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    shardingInstanceMongoListToKotlin(args0)
                })
            })
        })

    /**
     * The name of DB instance. It must be 2 to 256 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network type of the instance. Valid values:`Classic` or `VPC`.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * The type of configuration changes performed. Default value: `DOWNGRADE`. Valid values:
     * - `UPGRADE`: The specifications are upgraded.
     * - `DOWNGRADE`: The specifications are downgraded.
     * **NOTE:** `order_type` is only applicable to instances when `instance_charge_type` is `PrePaid`.
     */
    public val orderType: Output<String>?
        get() = javaResource.orderType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration that you will buy DB instance (in month). It is valid when `instance_charge_type` is `PrePaid`. Default value: `1`. Valid values: [1~9], 12, 24, 36.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The type of the access protocol. Valid values: `mongodb` or `dynamodb`.
     */
    public val protocolType: Output<String>
        get() = javaResource.protocolType().applyValue({ args0 -> args0 })

    /**
     * The provisioned IOPS. Valid values: `0` to `50000`.
     */
    public val provisionedIops: Output<Int>?
        get() = javaResource.provisionedIops().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Resource Group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.42.0) Instance data backup retention days.
     */
    public val retentionPeriod: Output<Int>
        get() = javaResource.retentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The Security Group ID of ECS.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
     */
    public val securityIpLists: Output<List<String>>
        get() = javaResource.securityIpLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The Shard nodes of the instance. The shard-node count can be purchased is in range of [2, 32]. See `shard_list` below.
     */
    public val shardLists: Output<List<ShardingInstanceShardList>>
        get() = javaResource.shardLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    shardingInstanceShardListToKotlin(args0)
                })
            })
        })

    /**
     * The storage engine of the instance. Default value: `WiredTiger`. Valid values: `WiredTiger`, `RocksDB`.
     */
    public val storageEngine: Output<String>
        get() = javaResource.storageEngine().applyValue({ args0 -> args0 })

    /**
     * The storage type of the instance. Valid values: `cloud_essd1`, `cloud_essd2`, `cloud_essd3`, `cloud_auto`, `local_ssd`. **NOTE:** From version 1.229.0, `storage_type` can be modified. However, `storage_type` can only be modified to `cloud_auto`.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The TDE(Transparent Data Encryption) status. It can be updated from version 1.160.0.
     */
    public val tdeStatus: Output<String>
        get() = javaResource.tdeStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The virtual switch ID to launch DB instances in one VPC.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The Zone to launch the DB instance. MongoDB Sharding Instance does not support multiple-zone.
     * If it is a multi-zone and `vswitch_id` is specified, the vswitch must in one of them.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ShardingInstanceMapper : ResourceMapper<ShardingInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.mongodb.ShardingInstance::class == javaResource::class

    override fun map(javaResource: Resource): ShardingInstance = ShardingInstance(
        javaResource as
            com.pulumi.alicloud.mongodb.ShardingInstance,
    )
}

/**
 * @see [ShardingInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ShardingInstance].
 */
public suspend fun shardingInstance(
    name: String,
    block: suspend ShardingInstanceResourceBuilder.() -> Unit,
): ShardingInstance {
    val builder = ShardingInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ShardingInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun shardingInstance(name: String): ShardingInstance {
    val builder = ShardingInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
